/*
 * Copyright (c) 2003-2011, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.html or http://ckeditor.com/license
*/

// The following script is used in CKEditorControl:OnPreRender
var CKEditor_Controls = [],
	CKEditor_Init = [];

function CKEditor_TextBoxEncode(cID, inUpdatePanel) {
	if (typeof CKEDITOR == 'undefined' || typeof CKEDITOR.instances[cID] == 'undefined') {
		var control = document.getElementById(cID);
		control.value = control.value.replace(/</g, '&lt;').replace(/>/g, '&gt;');
	} 
	else {
		var e = CKEDITOR.instances[cID];
		if (inUpdatePanel) 
			e.destroy();
		else
			e.updateElement();
	}
};

(function()
{
	var onload = function()
	{
		var ids = CKEditor_Controls,
			initFunctions = CKEditor_Init,
			oldPageLoad = window.pageLoad;

		var loadEditors = function() {
			for (var i = ids.length; i--;) {
				var e = document.getElementById(ids[i]);
				if (e && e.value && (e.value.indexOf('<') ==-1 || e.value.indexOf('>') ==-1)) {
					e.value = e.value.replace(/&lt;/g, '<').replace(/&gt;/g, '>').replace(/&amp;/g, '&');
				}
			}
			if (typeof CKEDITOR != 'undefined') {
				for (var i = 0; i < initFunctions.length; i++) {
					initFunctions[i].call(this);
				}
			}
		};

		window.pageLoad = function(sender, args) {
			if (args.get_isPartialLoad()) {
				setTimeout(loadEditors, 0);
			}
			if (oldPageLoad && typeof oldPageLoad == 'function') {
				oldPageLoad.call(this, sender, args);
			}
		};

		setTimeout(loadEditors, 0);
	};

	if ( window.addEventListener )
		window.addEventListener( 'load', onload, false );
	else if ( window.attachEvent )
		window.attachEvent( 'onload', onload );
})();