/*
Copyright (c) 2003-2011, CKSource - Frederico Knabben. All rights reserved.
For licensing, see LICENSE.html or http://ckeditor.com/license
 */

importPackage( org.mozilla.javascript );
importClass( java.lang.System );
importClass( java.io.File );

/*
 * Check if we're running the compiled version of this script. If yes, the
 * langtool class should be available.
 */
var isCompiled = true;
var command = "java -cp js.jar org.mozilla.javascript.tools.shell.Main langtool.js";
var resource = JavaAdapter( org.mozilla.javascript.Parser )["class"].getResource( "/org/mozilla/javascript" ).toString();

try
{
	java.lang.Class.forName( "cklangtool.langtool" );
}
catch ( e )
{
	isCompiled = false;
}

var cklangtoolPath = '';

if ( isCompiled )
{
	var quit = function()
	{
		System.exit( 0 );
	};

	loadClass( 'cklangtool.includes.cklangtool' );

	var resource = JavaAdapter( org.mozilla.javascript.Parser )["class"].getResource( "/org/mozilla/javascript" ).toString();
	if ( resource.indexOf( ".exe" ) )
		command = "langtool.exe";
	else
		command = "java -jar langtool.jar";
}
else
{
	cklangtoolPath = resource.replaceFirst( "^jar:", '' ).replaceFirst( "\/js\.jar\!\/org\/mozilla\/javascript$", '' )
			.replaceAll( "_dev.{1}_thirdparty.{1}rhino", "" );

	load( cklangtoolPath + "_source/includes/cklangtool.js" );

	CKLANGTOOL.path = cklangtoolPath;
}

CKLANGTOOL.isCompiled = isCompiled;
CKLANGTOOL.load( 'cklangtool.includes.ckjpformat' );
CKLANGTOOL.load( 'cklangtool.includes.ckpoformat' );
CKLANGTOOL.load( 'cklangtool.includes.io' );

if ( !arguments[0] || arguments[0] == '-help' || arguments[0] == '/?' )
	error( 'Usage: ' + command + ' lang_dir [-jpformat=dest_dir]|[-poformat=dest_dir] [-metafile=path]'
			+ '\n\n CKLangTool corrects translation files and creates report about missing translations.'
			+ '\n\n -jpformat  Convert files to java properties format and save them in dest_dir'
			+ '\n\n -poformat  Convert files to GNU gettext PO format and save them in dest_dir.'
			+ '\n\n -metafile  Path to meta file (used only in conjuction with -poformat).'
			+ '\n' );

for ( var i = 0 ; i < arguments.length ; i++ )
{
	var arg = arguments[i], match;
	if ( match = arg.match( /^-(\w+format)=(.*?)$/ ) )
	{
		var destDir = match[ 2 ];
		CKLANGTOOL.destinationDir = new File( destDir );
		if ( CKLANGTOOL.destinationDir.exists() )
			error( 'Destination directory already exists: ' + CKLANGTOOL.destinationDir.getAbsolutePath() );
		else
			CKLANGTOOL.destinationDir.mkdir();
		CKLANGTOOL.format = match[ 1 ];
	}
	if ( match = arg.match( /^-metafile=(.*?)$/ ) )
	{
		var metafilePath = match[ 1 ];
		CKLANGTOOL.metafilePath = new File( metafilePath );
		if ( !CKLANGTOOL.metafilePath.exists() )
			error( 'Meta file does not exist: ' + CKLANGTOOL.metafilePath.getAbsolutePath() );
	}
}

if ( arguments[0] == '-test' && !isCompiled )
{
	CKLANGTOOL.load( 'test.test' );
	quit();
}

CKLANGTOOL.languageDir = new File( arguments[0] );
CKLANGTOOL.templateFile = new File( arguments[0], 'en.js' );

if ( !CKLANGTOOL.templateFile.exists() )
{
	error( 'ERROR: The english language file "en.js" was not found (' + CKLANGTOOL.templateFile.getAbsolutePath() + ')' );
}

function error( msg )
{
	System.err.println( msg );
	quit();
}

( function()
{
	try
	{
		if ( CKLANGTOOL.format == "json" )
		{
			var translator = new CKLANGTOOL.translator();
			translator.run();

		}
		// Convert or sync languages files from other format.
		else
		{
			var format = new CKLANGTOOL[ CKLANGTOOL.format ]();
			format.run();
		}
	}
	catch ( e )
	{
		error( e );
	}
} )();
