/**
 * @tc
 * @name test list creation with language direction merged (#7748).
 * @tags list,bidi
 * @browsers ie,ff
 */

// Load the page, switch the demo page language to 'en'.
browser.get( vars[ 'base' ] + "ui_languages.html" );
sampleLanguageTo( 'en' );

var editor = browser.editor( 'editor1' );

// Create a list which has text direction and then merge with the above one.
editor.data( '<ol><li>ltr</li></ol><p dir="rtl">rtl</p>' );
editor.selection( "//p[1]`0,//p[1]`1" ).button( 'Insert/Remove Numbered List' );

var expected = '<ol><li>ltr</li><li dir="rtl">rtl</li></ol>';
Assert.areEqual(expected, editor.compactData(), "Editor output doesn't match." );
