/**
 * @tc
 * @name test paste should split block element.
 * @tags copy,paste
 * @browsers ie,ff
 */

// Load the page, switch the demo page language to 'en'.
browser.get( vars[ 'base' ] + "ui_languages.html" );
sampleLanguageTo( 'en' );

var editor = browser.editor( 'editor1' );

// Create a list which has text direction and then merge with the above one.
editor.data( '<h1>heading1</h1>' );
editor.type( Keys.CONTROL, 'a' ).type( Keys.CONTROL, 'c' ).type( Keys.END ).type( Keys.ARROW_LEFT, 5 ).type( Keys.CONTROL, 'v' );
var expected = '<h1>hea</h1><h1>heading1</h1><h1>ding1</h1>';
var actual = browser.cleanHtml( editor.runAtEditor( function() { return editor.getSnapshot(); } ) ).replace( /<br[^>]*>/ig, '' );
Assert.areEqual(expected, actual, "Editor output doesn't match." );
