/**
 * @tc
 * @name test list creation with language direction merged (#7748).
 * @tags list,bidi
 * @browsers ie,ff
 */

// Load the page, switch the demo page language to 'en'.
browser.get( vars[ 'base' ] + "ui_languages.html" );
sampleLanguageTo( 'en' );

var editor = browser.editor( 'editor1' );

// Create list from a RTL paragraph with the above LTR list merged.
editor.data( '<ol><li>ltr</li></ol><p dir="rtl">rtl</p>' );
editor.selection( "//p[1]`0,//p[1]`1" ).button( 'Insert/Remove Numbered List' );

var expected = '<ol><li>ltr</li><li dir="rtl">rtl</li></ol>';
Assert.areEqual(expected, editor.compactData(), "Editor output doesn't match." );

// Create list from a LTR paragraph with the above RTL list merged.
editor.data( '<ol dir="rtl"><li>rtl</li></ol><p>ltr</p>' );
editor.selection( "//p[1]`0,//p[1]`1" ).button( 'Insert/Remove Numbered List' );

var expected = '<ol><li dir="rtl">rtl</li><li>ltr</li></ol>';
Assert.areEqual(expected, editor.compactData(), "Editor output doesn't match." );
