/**
 * @tc
 * @name test paste should split block element.
 * @tags copy,paste
 * @browsers ie,ff
 */

// Load the page, switch the demo page language to 'en'.
browser.get( vars[ 'base' ] + "ui_languages.html" );
sampleLanguageTo( 'en' );

var editor = browser.editor( 'editor1' );

// Create a list which has text direction and then merge with the above one.
editor.data( '<h1>foo</h1><p>bar</p>' );
editor.type( Keys.CONTROL, 'a' ).type( Keys.CONTROL, 'c' ).type( Keys.ARROW_UP, Keys.END ).type( Keys.CONTROL, 'v' );
var expected = '<h1>foo</h1><h1>foo</h1><p>bar</p><p>bar</p>';
var actual = browser.cleanHtml( editor.runAtEditor( function() { return editor.getSnapshot(); } ), { lowerCase: 1 } ).replace( /<br[^>]*>/ig, '' );
Assert.areEqual(expected, actual, "Editor output doesn't match." );
