/*
 * Copyright (c) 2003-2011, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.html or http://ckeditor.com/license
*/

// The following script is used in CKEditorControl:OnPreRender
var CKEditor_Controls = [],
	CKEditor_Init = [];

function CKEditor_TextBoxEncode(cID, inUpdatePanel) {
	var control;
	if (typeof CKEDITOR == 'undefined' || typeof CKEDITOR.instances[cID] == 'undefined') {
		control = document.getElementById(cID);
		if (control)
			control.value = control.value.replace(/</g, '&lt;').replace(/>/g, '&gt;');
	} 
	else {
		var e = CKEDITOR.instances[cID];
		if (inUpdatePanel && (typeof Page_BlockSubmit == 'undefined' || !Page_BlockSubmit)) {
			e.destroy();
			control = document.getElementById(cID);
			if (control)
				control.style.visibility = 'hidden';
		}
		else
			e.updateElement();
	}
};

(function()
{
	if (typeof CKEDITOR != 'undefined')
	{
		// #this.ClientID# will be replaced with the correct ID of CKEditor instance.
		// string.Format and {0} cannot be used in C# without escaping curly braces in JavaScript code,
		// which would cause problems with JavaScript minification by CKPackager.
		var control = document.getElementById('#this.ClientID#');
		if (control)
			control.style.visibility = 'hidden';
	}

	var onload = function()
	{
		var ids = CKEditor_Controls,
			initFunctions = CKEditor_Init,
			oldPageLoad = window.pageLoad;

		var loadEditors = function() {
			for (var i = ids.length; i--;) {
				var e = document.getElementById(ids[i]);
				if (e && e.value && (e.value.indexOf('<') ==-1 || e.value.indexOf('>') ==-1)) {
					e.value = e.value.replace(/&lt;/g, '<').replace(/&gt;/g, '>').replace(/&amp;/g, '&');
				}
			}
			if (typeof CKEDITOR != 'undefined') {
				for (var i = 0; i < initFunctions.length; i++) {
					initFunctions[i].call(this);
				}
			}
		};

		window.pageLoad = function(sender, args) {
			if (args.get_isPartialLoad()) {
				setTimeout(loadEditors, 0);
			}
			if (oldPageLoad && typeof oldPageLoad == 'function') {
				oldPageLoad.call(this, sender, args);
			}
		};

		setTimeout(loadEditors, 0);
	};
	if(typeof Sys != 'undefined' && typeof Sys.Application != 'undefined')
		Sys.Application.add_load(onload);
	if ( window.addEventListener )
		window.addEventListener( 'load', onload, false );
	else if ( window.attachEvent )
		window.attachEvent( 'onload', onload );
})();