/*
Copyright (c) 2003-2011, CKSource - Frederico Knabben. All rights reserved.
For licensing, see LICENSE.html or http://ckeditor.com/license
*/

importPackage( java.util.regex );
importClass( java.text.SimpleDateFormat );

( function()
{
	/*
	 * An array with missing keys in current translation.
	 */
	var metaInformation;

	CKLANGTOOL.meta = function()
	{
		return {
			run : function()
			{
				metaInformation = loadMetaInformation();

				var file = new File( CKLANGTOOL.destinationDir, 'meta.txt' );
				CKLANGTOOL.io.saveFile( file, processFile(CKLANGTOOL.templateFile), false );

				print( "Process completed." );
			}
		};
	};

	/**
	 * Meta file stores an extra information about each string (context, user friendly description).
	 * The format is:
	 * fieldId = information
	 *
	 * Sample entry:
	 * link.noUrl = Error message shown to the user when URL field is empty.
	 */
	function loadMetaInformation()
	{
		if (!CKLANGTOOL.metaFile)
			return {};

		var lines = CKLANGTOOL.io.readFileIntoArray(CKLANGTOOL.metaFile);
		var meta = {};

		for ( var j = 0 ; j < lines.length ; j++ )
		{
			var line = lines[ j ];
			if ( match = line.match( /^\s*([a-z0-9_.]+)\s*=\s*(.*)\s*$/i ) )
			{
				meta[match[1]] = match[2];
			}
		}
		return meta;
	}

	function printObject( prefix, o )
	{
		var result = [];

		for ( var key in o )
		{
			var entry = o[ key ],
				entryName = prefix ? ( prefix + '.' + key ) : key;

			if ( typeof entry == 'object' )
				result.push( printObject( entryName, entry ) );
			else
				result.push( poEntry( entryName, entry ) );
		}

		return result.join( '' );
	}

	function msgstrEscape( str )
	{
		return str.replace( /"/g, '\\"' ).replace( /\r\n|\n/g, '\\n"$&"' );
	}

	/**
	 *  Generate a PO translation entry with the following schematic structure:
	 *	whte-space
	 *	# translator-comments
	 *	#.extracted-comments
	 *	#:reference...
	 *	#,flag...
	 *	#|msgid previous-untranslated-string
	 *	msid untranslated-string
	 *	msstr translated-string
	 *
	 * @param {String} id The untranslated string part.
	 * @param {String} str The translated-string part.
	 * @param {String} [ comment1, comment2... ] Translator comments.
	 */
	function poEntry( id, str, comment )
	{
		var str = "";
		if ( metaInformation[id] )
			str = metaInformation[id];
		return id + ' = ' + str + '\n';
	}

	function processFile( file )
	{
		// License Info
		var date = new Date(),
			license = '# Copyright (c) 2003-' + date.getFullYear() + ', CKSource - Frederico Knabben. All rights reserved.\n# For licensing, see LICENSE.html or http://ckeditor.com/license\n\n';

		var language = CKLANGTOOL.loadLanguageFile( file, 'json' );
		return license + printObject( '', language.translation );
	}

})();
