﻿/*
 * FCKeditor - The text editor for Internet - http://www.fckeditor.net
 * Copyright (C) 2003-2007 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 *
 * FCKToolbarPanelButton Class: Handles the Fonts combo selector.
 */

var FCKToolbarFontSizeCombo = function( tooltip, style )
{
	this.CommandName	= 'FontSize' ;
	this.Label		= this.GetLabel() ;
	this.Tooltip	= tooltip ? tooltip : this.Label ;
	this.Style		= style ? style : FCK_TOOLBARITEM_ICONTEXT ;
	
	this.DefaultLabel = FCKConfig.DefaultFontSizeLabel || '' ;
}

// Inherit from FCKToolbarSpecialCombo.
FCKToolbarFontSizeCombo.prototype = new FCKToolbarSpecialCombo ;

FCKToolbarFontSizeCombo.prototype.TypeOf = 'FCKToolbarFontSizeCombo' ;		// @Packager.RemoveLine

FCKToolbarFontSizeCombo.prototype.GetLabel = function()
{
	return FCKLang.FontSize ;
}

FCKToolbarFontSizeCombo.prototype.CreateItems = function( targetSpecialCombo )
{
	var style = FCKStyles.GetStyle( '_FCK_Size' ) ;

	targetSpecialCombo.FieldWidth = 70 ;

	var sizes = FCKConfig.FontSizes.split(';') ;

	for ( var i = 0 ; i < sizes.length ; i++ )
	{
		var sizeParts = sizes[i].split('/') ;
		var size = sizeParts[0] ;
		var caption = sizeParts[1] || size ;

		style.SetVariable( 'Size', size ) ;
		
		this._Combo.AddItem( size, FCKToolbarStyleCombo_BuildPreview( style, caption ), caption ) ;
	}
}