﻿/*
 * FCKeditor - The text editor for Internet - http://www.fckeditor.net
 * Copyright (C) 2003-2007 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 *
 * FCKToolbarPanelButton Class: Handles the Fonts combo selector.
 */

var FCKToolbarFontsCombo = function( tooltip, style )
{
	this.CommandName	= 'FontName' ;
	this.Label		= this.GetLabel() ;
	this.Tooltip	= tooltip ? tooltip : this.Label ;
	this.Style		= style ? style : FCK_TOOLBARITEM_ICONTEXT ;

	this.DefaultLabel = FCKConfig.DefaultFontLabel || '' ;
}

// Inherit from FCKToolbarSpecialCombo.
FCKToolbarFontsCombo.prototype = new FCKToolbarFontFormatCombo( false ) ;

FCKToolbarFontsCombo.prototype.TypeOf = 'FCKToolbarFontsCombo' ;		// @Packager.RemoveLine

FCKToolbarFontsCombo.prototype.GetLabel = function()
{
	return FCKLang.Font ;
}

FCKToolbarFontFormatCombo.prototype.GetStyles = function()
{
	var baseStyle = FCKStyles.GetStyle( '_FCK_FontFace' ) ;

	var styles = {} ;

	var fonts = FCKConfig.FontNames.split(';') ;

	for ( var i = 0 ; i < fonts.length ; i++ )
	{
		var fontParts = fonts[i].split('/') ;
		var font = fontParts[0] ;
		var caption = fontParts[1] || font ;

		var style = FCKTools.CloneObject( baseStyle ) ;
		style.SetVariable( 'Font', font ) ;
		style.Label = caption ;

		styles[ caption ] = style ;
	}

	return styles ;
}

//FCKToolbarFontsCombo.prototype.CreateItems = function( targetSpecialCombo )
//{
//	var style = FCKStyles.GetStyle( '_FCK_FontFace' ) ;

//	var fonts = FCKConfig.FontNames.split(';') ;

//	for ( var i = 0 ; i < fonts.length ; i++ )
//	{
//		var fontParts = fonts[i].split('/') ;
//		var font = fontParts[0] ;
//		var caption = fontParts[1] || font ;

//		style.SetVariable( 'Font', font ) ;

//		this._Combo.AddItem( font, '<span style="font-size: 12px">' + FCKToolbarStyleCombo_BuildPreview( style, caption ) + '</span>', caption ) ;
//	}
//}

//FCKToolbarFontsCombo.prototype.RefreshActiveItems = FCKToolbarFontFormatCombo.prototype.RefreshActiveItems ;