﻿/*
 * FCKeditor - The text editor for Internet - http://www.fckeditor.net
 * Copyright (C) 2003-2007 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 *
 * Implementation for the "Insert/Remove Ordered/Unordered List" commands.
 */

var FCKListCommand = function( tagName )
{
	this.TagName = tagName;
}

FCKListCommand.prototype = 
{
	GetState : function()
	{
		if ( FCK.EditMode != FCK_EDITMODE_WYSIWYG || ! FCK.EditorWindow )
			return FCK_TRISTATE_DISABLED ;
		var terminals = FCKSelection.GetSelectionTerminals() ;
		var listBlock = this._GetNearestListParent( terminals.startNode, terminals.endNode ) ;
		if ( listBlock )
			return FCK_TRISTATE_ON ;
		else
			return FCK_TRISTATE_OFF ;
	},

	Execute : function()
	{
		if ( this.GetState() == FCK_TRISTATE_OFF )
		{
			// Get the selected items ranges.
			var selectionRange = FCKSelection.GetSelectionRange() ;
			var itemRanges = selectionRange.GetSelectedParagraphs() ;

			// Cut the contents of the items into document fragments.
			// For each item contents, find the shallowest tree depth and work from that level.
			var markerObj = {} ;
			var itemDocFragments = [] ;
			for ( var i = 0 ; i < itemRanges.length ; i++ ) 
			{
				// find out the shallowest node by dynamic programming.
				var currentItem = itemRanges[i] ;
				var currentNode = currentItem._Range.startContainer ;
				if ( currentNode.nodeType == 1 && currentNode.lastChild )
					currentNode = currentNode.childNodes[ currentItem._Range.startOffset ] ;
				var startNode = currentNode ;
				var endNode = currentItem._Range.endContainer ;
				if ( endNode.nodeType == 1 && endNode.lastChild )
					endNode = endNode.childNodes[ currentItem._Range.endOffset ] ;
				endNode = FCKDomTools.GetNextSourceNode( endNode ) ;
				var shallowestNode = startNode ;
				var inlineShallowestNode = startNode ;
				itemRanges[i] = {
					'range' : currentItem ,
					'start' : startNode,
					'end' : endNode,
					'top' : null,
					'topDepth' : null ,
				} ;
				while ( currentNode != endNode )
				{
					var unmarkedNodes = [] ;
					// for each node, loop through its parents until either document.body or a marked node is found.
					// also, keep record of the unmarked nodes encountered.
					var ancestor = currentNode ;
					while ( ancestor != ancestor.ownerDocument.body
					     && ancestor._FCKDepthCounter == undefined )
					{
						unmarkedNodes.unshift( ancestor ) ;
						ancestor = ancestor.parentNode ;
					}
					var topDepth = ( ancestor == ancestor.ownerDocument.body ? 0 : ancestor._FCKDepthCounter ) ;
					for ( var j = 0 ; j < unmarkedNodes.length ; j++ )
					{
						FCKDomTools.SetNodeMarker( markerObj, unmarkedNodes[j], '_FCKDepthCounter', 
							       topDepth + 1 + j ) ;
						/*
						FCKDebug.Output( unmarkedNodes[j].nodeName + ":" + unmarkedNodes[j]._FCKDepthCounter + ":" + 
						    ( topDepth + 1 + j ) ) ;
						*/
					}
					if ( currentNode._FCKDepthCounter < shallowestNode._FCKDepthCounter )
						shallowestNode = currentNode ;
					currentNode = FCKDomTools.GetNextSourceNode( currentNode ) ;
				}
				itemRanges[i].top = shallowestNode ;
				itemRanges[i].topDepth = shallowestNode._FCKDepthCounter ;
			}

			for ( var i = 0 ; i < itemRanges.length ; i++ )
			{
				// Create the document fragment for the item.
				var currentFragment = selectionRange.Window.document.createDocumentFragment() ;
				itemDocFragments.push( currentFragment ) ;
				var startNode = itemRanges[i].start ;
				var endNode = itemRanges[i].end ;
				var itemMarkers = {} ;

				currentNode = startNode ;
				while ( currentNode != endNode )
				{
					var ancestor = currentNode ;
					var previousImage = null ;
					var currentImage = null ;
					while ( ancestor._FCKDepthCounter >= itemRanges[i].topDepth ) 
					{
						if ( ancestor._FCKCurrentImage )
							currentImage = ancestor._FCKCurrentImage ;
						else
						{
							/*
							FCKDebug.Output( i + ":" + ancestor.nodeName + ":" + currentNode.nodeName + 
									":" + (ancestor == currentNode) ) ;
							*/
							currentImage = ancestor.cloneNode( false ) ;
							FCKDomTools.SetNodeMarker( itemMarkers, ancestor, '_FCKCurrentImage', currentImage ) ;
						}
						if ( previousImage )
							currentImage.appendChild( previousImage ) ;
						previousImage = currentImage ;
						ancestor = ancestor.parentNode ;
					}
					if ( currentImage.parentNode == null )
						currentFragment.appendChild( currentImage ) ;
					currentNode = FCKDomTools.GetNextSourceNode( currentNode ) ;
				}

				FCKDomTools.ClearNodeMarkers( itemMarkers ) ;
			}

			// For testing and debug use
			/*
			for ( var i = 0 ; i < itemDocFragments.length ; i++ )
			{
				var tmp = selectionRange.Window.document.createElement( 'div' ) ;
				tmp.appendChild( itemDocFragments[i] ) ;
				FCKDebug.Output( tmp.innerHTML ) ;
			}
			*/

			// Now we should have a list of document fragments corresponding to individual list items.
			// We should not create the list immediately, however. Due to the following reasons:
			// 1. Multiple lists might be needed if parts of the list are in tables.
			// 	This case is not mentioned in Midas list rules (http://www.mozilla.org/editor/list-rules.html)
			//	But the behavior can be tested in the built-in insert list commands of both IE and Midas.
			//	Let's model it this way: if any of the tree nodes between this node (exclusive) and the parent node
			// 	at depth=nearestCommonParent (inclusive), is a PathBlockLimitElement, then a new list is needed.
			// 2. If any of the selected list items are already list items, take care not to change the indentation
			//	or invalidate the non-selected list items of the same list.
			//	(Midas list rules G, H, I, J, and note that Midas's case I is somewhat inconsistent!!)
			// 3. After we've created the lists, where should we insert them to?
			// 	Look for the highest level item in the list, and insert the list right before the highest level
			//	item's original nextSibling.

			/*
			// Array containing information of list blocks that needs to be inserted -
			// The list node themselves, and where they should be inserted to
			var listBlocks = [] ;
			
			// Get the common parents of the range and read the nearest common parent's tree depth.
			var startTerminal = itemRanges[0].GetTerminalNodes().startNode ;
			var endTerminal = itemRanges[itemRanges.length - 1].GetTerminalNodes().endNode ;
			var nearestCommonParent = FCKTools.GetCommonParents( startTerminal, endTerminal ).pop() ;
			var nearestParentDepth = nearestCommonParent.nodeName.IEquals( 'body' ) ? 
				0 : nearestCommonParent._FCKDepthCounter ;
			var currentListBlock = {
				'node' : selectionRange.Window.document.createElement( this.TagName ),
				'parent' : null,
				'next' : null
			} ;

			for ( var i = 0 ; i < itemDocFragments.length ; i++ )
			{
				var previousParent = itemDocFragments[i].firstChild._FCKPreviousParent ;
				var ancestor = previousParent ;
				if ( currentListBlock.parent == null )
				{
					currentListBlock.parent = previousParent ;
					currentListBlock.next = itemDocFragments.lastChild._FCKPreviousNextSibling ;
				}
				while ( ancestor._FCKDepthCounter >= nearestParentDepth )
				{
					if ( FCKListsLib.PathBlockLimitElements[ancestor.nodeName.toLowerCase()] )
					{
					}
				}
			}
			*/

			// Clean up all the markings
			FCKDomTools.ClearNodeMarkers( markerObj ) ;
		}
		else if ( this.GetState() == FCK_TRISTATE_ON )
		{
		}
		/*
		if ( FCKBrowserInfo.IsIE && this.GetState() == FCK_TRISTATE_OFF )
		{
			// IE does not split selected <br> tags when it is making lists. (See #428)
			// So, pre-split the blocks for IE.
			var range = FCKSelection.GetSelectionRange() ;
			var items = range.GetSelectedParagraphs() ;
			for ( var i = 0 ; i < items.length ; i++ )
			{
				try
				{
					var itemContents = items[i].ExtractContents() ;
					var dummyBlock = FCK.EditorDocument.createElement( 'div' ) ;
					items[i].InsertNode( dummyBlock ) ;
					itemContents.AppendTo( dummyBlock ) ;
				}
				catch ( e ) {}
			}
			range.Select() ;
		}
		*/
		//FCK.ExecuteNamedCommand( this.Name ) ;
	},

	_GetNearestListParent : function( node1, node2 )
	{
		var commonParents = FCKDomTools.GetCommonParents( node1, node2 ) ;
		for ( var i = commonParents.length - 1 ; i >= 0 ; i-- )
		{
			var tagName = String(commonParents[i].tagName) ;
			if ( tagName.IEquals( [ 'ul', 'ol' ] ) )
			{
				if ( tagName.IEquals( this.TagName ) )
					return commonParents[i] ;
				else
					return null ;
			}
		}
		return null ;
	}
};
