﻿/*
 * FCKeditor - The text editor for Internet - http://www.fckeditor.net
 * Copyright (C) 2003-2007 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 *
 * FCKBlockQuoteCommand Class: adds or removes blockquote tags.
 */

var FCKBlockQuoteCommand = function()
{
}

FCKBlockQuoteCommand.prototype = 
{
	Execute : function()
	{
		FCKUndo.SaveUndoStep() ;

		var state = this.GetState() ;
		var range = new FCKDomRange( FCK.EditorWindow ) ;
		range.MoveToSelection() ;
		var bookmark = range.CreateBookmark() ;
		var iterator = new FCKDomRangeIterator( range ) ;
		var block ;

		if ( state == FCK_TRISTATE_OFF )
		{
			range.Expand( 'block_contents' ) ;
			range.SetStart( range.StartContainer, 3 ) ;
			range.SetEnd( range.EndContainer, 4 ) ;
			var oldStart = range.StartContainer ;
			var oldEnd = range.EndContainer ;
			var docFrag = range.ExtractContents() ;
			var quoteBlock = range.Window.document.createElement( 'blockquote' ) ;
			docFrag.AppendTo( quoteBlock ) ;
			range.InsertNode( quoteBlock ) ;
			if ( ! oldStart.lastChild )
				oldStart.parentNode.removeChild( oldStart ) ;
			if ( ! oldEnd.lastChild )
				oldEnd.parentNode.removeChild( oldEnd ) ;
		}
		else if ( state == FCK_TRISTATE_ON )
		{
			var bqBlocks = [] ;
			while ( ( block = iterator.GetNextParagraph() ) )
			{
				var bqParent = this._GetBlockquoteParent( block ) ;
				if ( ! bqParent )
					continue ;

				if ( bqParent._FCK_AREADY_ADDED )
					continue ;

				bqBlocks.push( bqParent ) ;
				bqParent._FCK_AREADY_ADDED = true ;
			}

			while ( bqBlocks.length > 0 )
			{
				var blockquote = bqBlocks.shift() ;
				var fragment = blockquote.ownerDocument.createDocumentFragment() ;
				while ( blockquote.firstChild )
					fragment.appendChild( blockquote.removeChild( blockquote.firstChild ) ) ;
				blockquote.parentNode.replaceChild( fragment, blockquote ) ;
			}
		}
		range.MoveToBookmark( bookmark ) ;
		range.Select() ;
		FCK.Events.FireEvent( 'OnSelectionChange' ) ;
	},

	GetState : function()
	{
		// Disabled if not WYSIWYG.
		if ( FCK.EditMode != FCK_EDITMODE_WYSIWYG || ! FCK.EditorWindow )
			return FCK_TRISTATE_DISABLED ;

		var path = new FCKElementPath( FCKSelection.GetBoundaryParentElement( true ) ) ;
		var firstBlock = path.Block || path.BlockLimit ;

		if ( !firstBlock || firstBlock.nodeName.toLowerCase() == 'body' )
			return FCK_TRISTATE_OFF ;

		// See if the first block has a blockquote parent.
		for ( var i = 0 ; i < path.Elements.length ; i++ )
		{
			if ( path.Elements[i].nodeName.IEquals( 'blockquote' ) )
				return FCK_TRISTATE_ON ;
		}
		return FCK_TRISTATE_OFF ;
	},

	_GetBlockquoteParent : function( node )
	{
		return FCKDomTools.GetCommonParentNode( node, node, 'blockquote' ) ;
	}
} ;
