﻿/*
Copyright (c) 2003-2013, CKSource - Frederico Knabben. All rights reserved.
For licensing, see LICENSE.html or http://ckeditor.com/license
*/

/**
 * @fileOverview Defines the {@link CKEDITOR.lang} object, for the
 * Portuguese language.
 */

/**#@+
   @type String
   @example
*/

/**
 * Contains the dictionary of language entries.
 * @namespace
 */
CKEDITOR.lang['pt'] =
{
	/**
	 * The language reading direction. Possible values are "rtl" for
	 * Right-To-Left languages (like Arabic) and "ltr" for Left-To-Right
	 * languages (like English).
	 * @default 'ltr'
	 */
	dir : 'ltr',

	/*
	 * Screenreader titles. Please note that screenreaders are not always capable
	 * of reading non-English words. So be careful while translating it.
	 */
	editorTitle : 'Rich text editor, %1', // MISSING
	editorHelp : 'Press ALT 0 for help', // MISSING

	// ARIA descriptions.
	toolbars	: 'Editor de barras de ferramentas',
	editor		: 'Editor de texto enriquecido',

	// Toolbar buttons without dialogs.
	source			: 'Fonte',
	newPage			: 'Nova Página',
	save			: 'Guardar',
	preview			: 'Pré-visualizar',
	cut				: 'Cortar',
	copy			: 'Copiar',
	paste			: 'Colar',
	print			: 'Imprimir',
	underline		: 'Sublinhado',
	bold			: 'Negrito',
	italic			: 'Itálico',
	selectAll		: 'Seleccionar Tudo',
	removeFormat	: 'Eliminar Formato',
	strike			: 'Rasurado',
	subscript		: 'Superior à Linha',
	superscript		: 'Inferior à Linha',
	horizontalrule	: 'Inserir Linha Horizontal',
	pagebreak		: 'Inserir Quebra de Página',
	pagebreakAlt		: 'Quebra de página',
	unlink			: 'Eliminar Hiperligação',
	undo			: 'Anular',
	redo			: 'Repetir',

	// Common messages and labels.
	common :
	{
		browseServer	: 'Navegar no Servidor',
		url				: 'URL',
		protocol		: 'Protocolo',
		upload			: 'Carregar',
		uploadSubmit	: 'Enviar para o Servidor',
		image			: 'Imagem',
		flash			: 'Flash',
		form			: 'Formulário',
		checkbox		: 'Caixa de Verificação',
		radio			: 'Botão de Opção',
		textField		: 'Campo de Texto',
		textarea		: 'Área de Texto',
		hiddenField		: 'Campo Escondido',
		button			: 'Botão',
		select			: 'Caixa de Combinação',
		imageButton		: 'Botão de Imagem',
		notSet			: '<Não definido>',
		id				: 'Id',
		name			: 'Nome',
		langDir			: 'Orientação de idioma',
		langDirLtr		: 'Esquerda à Direita (LTR)',
		langDirRtl		: 'Direita a Esquerda (RTL)',
		langCode		: 'Código de Idioma',
		longDescr		: 'Descrição Completa do URL',
		cssClass		: 'Classes de Estilo de Folhas Classes',
		advisoryTitle	: 'Título',
		cssStyle		: 'Estilo',
		ok				: 'OK',
		cancel			: 'Cancelar',
		close			: 'Fechar',
		preview			: 'Pré-visualização',
		generalTab		: 'Geral',
		advancedTab		: 'Avançado',
		validateNumberFailed : 'This value is not a number.', // MISSING
		confirmNewPage	: 'Any unsaved changes to this content will be lost. Are you sure you want to load new page?', // MISSING
		confirmCancel	: 'Some of the options have been changed. Are you sure to close the dialog?', // MISSING
		options			: 'Opções',
		target			: 'Alvo',
		targetNew		: 'Nova Janela (_blank)',
		targetTop		: 'Janela superior (_top)',
		targetSelf		: 'Mesma janela (_self)',
		targetParent	: 'Parent Window (_parent)', // MISSING
		langDirLTR		: 'Left to Right (LTR)', // MISSING
		langDirRTL		: 'Direita para Esquerda (RTL)',
		styles			: 'Estilo',
		cssClasses		: 'Stylesheet Classes', // MISSING
		width			: 'Largura',
		height			: 'Altura',
		align			: 'Alinhamento',
		alignLeft		: 'Esquerda',
		alignRight		: 'Direita',
		alignCenter		: 'Centrado',
		alignTop		: 'Topo',
		alignMiddle		: 'Centro',
		alignBottom		: 'Fundo',
		invalidValue	: 'Invalid value.', // MISSING
		invalidHeight	: 'Height must be a number.', // MISSING
		invalidWidth	: 'Width must be a number.', // MISSING
		invalidCssLength	: 'Value specified for the "%1" field must be a positive number with or without a valid CSS measurement unit (px, %, in, cm, mm, em, ex, pt, or pc).', // MISSING
		invalidHtmlLength	: 'Value specified for the "%1" field must be a positive number with or without a valid HTML measurement unit (px or %).', // MISSING
		invalidInlineStyle	: 'Value specified for the inline style must consist of one or more tuples with the format of "name : value", separated by semi-colons.', // MISSING
		cssLengthTooltip	: 'Enter a number for a value in pixels or a number with a valid CSS unit (px, %, in, cm, mm, em, ex, pt, or pc).', // MISSING

		// Put the voice-only part of the label in the span.
		unavailable		: '%1<span class="cke_accessibility">, unavailable</span>' // MISSING
	},

	contextmenu :
	{
		options : 'Menu de opções de contexto'
	},

	// Special char dialog.
	specialChar		:
	{
		toolbar		: 'Inserir Caracter Especial',
		title		: 'Seleccione um caracter especial',
		options : 'Special Character Options' // MISSING
	},

	// Link dialog.
	link :
	{
		toolbar		: 'Inserir/Editar Hiperligação',
		other 		: '<outro>',
		menu		: 'Editar Hiperligação',
		title		: 'Hiperligação',
		info		: 'Informação de Hiperligação',
		target		: 'Destino',
		upload		: 'Carregar',
		advanced	: 'Avançado',
		type		: 'Tipo de Hiperligação',
		toUrl		: 'URL',
		toAnchor	: 'Referência a esta página',
		toEmail		: 'E-Mail',
		targetFrame		: '<Frame>',
		targetPopup		: '<Janela de popup>',
		targetFrameName	: 'Nome do Frame Destino',
		targetPopupName	: 'Nome da Janela de Popup',
		popupFeatures	: 'Características de Janela de Popup',
		popupResizable	: 'Redimensionável',
		popupStatusBar	: 'Barra de Estado',
		popupLocationBar: 'Barra de localização',
		popupToolbar	: 'Barra de Ferramentas',
		popupMenuBar	: 'Barra de Menu',
		popupFullScreen	: 'Janela Completa (IE)',
		popupScrollBars	: 'Barras de deslocamento',
		popupDependent	: 'Dependente (Netscape)',
		popupLeft		: 'Posição Esquerda',
		popupTop		: 'Posição Direita',
		id				: 'ID',
		langDir			: 'Orientação de idioma',
		langDirLTR		: 'Esquerda à Direita (LTR)',
		langDirRTL		: 'Direita a Esquerda (RTL)',
		acccessKey		: 'Chave de Acesso',
		name			: 'Nome',
		langCode			: 'Orientação de idioma',
		tabIndex			: 'Índice de Tubulação',
		advisoryTitle		: 'Título',
		advisoryContentType	: 'Tipo de Conteúdo',
		cssClasses		: 'Classes de Estilo de Folhas Classes',
		charset			: 'Fonte de caracteres vinculado',
		styles			: 'Estilo',
		rel			: 'Relação',
		selectAnchor		: 'Seleccionar una referência',
		anchorName		: 'Por Nome de Referência',
		anchorId			: 'Por ID de elemento',
		emailAddress		: 'Endereço de E-Mail',
		emailSubject		: 'Título de Mensagem',
		emailBody		: 'Corpo da Mensagem',
		noAnchors		: '(Não há referências disponíveis no documento)',
		noUrl			: 'Por favor introduza a hiperligação URL',
		noEmail			: 'Por favor introduza o endereço de e-mail'
	},

	// Anchor dialog
	anchor :
	{
		toolbar		: ' Inserir/Editar Âncora',
		menu		: 'Propriedades da Âncora',
		title		: 'Propriedades da Âncora',
		name		: 'Nome da Âncora',
		errorName	: 'Por favor, introduza o nome da âncora',
		remove		: 'Remove Anchor' // MISSING
	},

	// List style dialog
	list:
	{
		numberedTitle		: 'Numbered List Properties', // MISSING
		bulletedTitle		: 'Bulleted List Properties', // MISSING
		type				: 'Tipo',
		start				: 'Iniciar',
		validateStartNumber				:'List start number must be a whole number.', // MISSING
		circle				: 'Círculo',
		disc				: 'Disco',
		square				: 'Quadrado',
		none				: 'Nenhum',
		notset				: '<not set>',
		armenian			: 'Numeração armênia',
		georgian			: 'Georgian numbering (an, ban, gan, etc.)', // MISSING
		lowerRoman			: 'Lower Roman (i, ii, iii, iv, v, etc.)', // MISSING
		upperRoman			: 'Upper Roman (I, II, III, IV, V, etc.)', // MISSING
		lowerAlpha			: 'Lower Alpha (a, b, c, d, e, etc.)', // MISSING
		upperAlpha			: 'Upper Alpha (A, B, C, D, E, etc.)', // MISSING
		lowerGreek			: 'Lower Greek (alpha, beta, gamma, etc.)', // MISSING
		decimal				: 'Decimal (1, 2, 3, etc.)', // MISSING
		decimalLeadingZero	: 'Decimal leading zero (01, 02, 03, etc.)' // MISSING
	},

	// Find And Replace Dialog
	findAndReplace :
	{
		title				: 'Find and Replace', // MISSING
		find				: 'Procurar',
		replace				: 'Substituir',
		findWhat			: 'Texto a Procurar:',
		replaceWith			: 'Substituir por:',
		notFoundMsg			: 'O texto especificado não foi encontrado.',
		findOptions			: 'Find Options', // MISSING
		matchCase			: 'Maiúsculas/Minúsculas',
		matchWord			: 'Coincidir com toda a palavra',
		matchCyclic			: 'Match cyclic', // MISSING
		replaceAll			: 'Substituir Tudo',
		replaceSuccessMsg	: '%1 occurrence(s) replaced.' // MISSING
	},

	// Table Dialog
	table :
	{
	    toolbar : "Tabela",
	    title : "Propriedades da Tabela",
	    menu : "Propriedades da Tabela",
	    deleteTable : "Eliminar Tabela",
	    rows : "Linhas",
	    columns : "Colunas",
	    border : "Tamanho do Limite",
	    widthPc : "percentagem",
	    widthPx : "pixeis",
	    widthUnit : "unidade da largura" 
	    cellSpace : "Esp. e/células",
		cellPad : "Esp. interior",
		caption : "Título",
	    summary : "Sumário",
		headers : "Headers",
	    headersNone : "Nenhum",
	    headersColumn : "Primeira coluna",
	    headersRow : "Primeira Linha",
		headersBoth : "Ambos",
	    invalidRows : "O numero de linhas tem de ser um numero maior que 0.",
	    invalidCols : "O numero de colunas tem de ser um numero maior que 0.",
		invalidBorder : "O tamanho da borda tem de ser um numero.",
	    invalidWidth : "A largura da tabela tem de ser um numero.",
	    invalidHeight : "A altura da tabela tem de ser um numero.",
		invalidCellSpacing : "Cell spacing must be a positive number.",
		invalidCellPadding : "Cell padding must be a positive number.",

		cell :
		{
			menu 			: 'Célula',
	        insertBefore 	: 'Inserir Célula Antes',
	        insertAfter 	: 'Inserir Célula Depois',
	        deleteCell 		: 'Eliminar Célula',
	        merge 			: 'Unir Células',
	        mergeRight 		: 'Fundir à Direita',
	        mergeDown 		: 'Fundir para Baixo',
	        splitHorizontal : 'Dividir Célula na Horizontal',
	        splitVertical 	: 'Dividir Célula Vertical',
	        title 			: 'Propriedades da Célula',
	        cellType 		: 'Tipo de Célula',
	        rowSpan 		: 'Linhas Span',
	        colSpan 		: 'Colunas Span',
	        wordWrap 		: 'Moldar o texto',
	        hAlign 			: 'Alinhamento Horizontal',
	        vAlign 			: 'Alinhamento Vertical',
	        alignBaseline 	: 'Baseline',
	        bgColor 		: 'Cor de Fundo',
	        borderColor 	: 'Cor da Borda',
	        data 			: 'Dados',
	        header 			: 'Cabeçalho',
	        yes 			: 'Sim',
	        no 				: 'Não',
	        invalidWidth 	: 'A largura da célula tem de ser um numero.',
	        invalidHeight 	: 'A altura da célula tem de ser um numero.',
	        invalidRowSpan 	: 'Linhas span tem de ser um numero inteiro.',
	        invalidColSpan 	: 'Colunas span tem de ser um numero inteiro.',
	        chooseColor 	: 'Escolher'
		},

		row :
		{
			menu			: 'Linha',
			insertBefore	: 'Inserir Linha Antes',
			insertAfter		: 'Inserir Linha Depois',
			deleteRow		: 'Eliminar Linhas'
		},

		column :
		{
			menu			: 'Coluna',
			insertBefore	: 'Inserir Coluna Antes',
			insertAfter		: 'Inserir Coluna Depois',
			deleteColumn	: 'Eliminar Coluna'
		}
	},

	// Button Dialog.
	button :
	{
		title		: 'Propriedades do Botão',
		text		: 'Texto (Valor)',
		type		: 'Tipo',
		typeBtn		: 'Botão',
		typeSbm		: 'Submeter',
		typeRst		: 'Repor'
	},

	// Checkbox and Radio Button Dialogs.
	checkboxAndRadio :
	{
		checkboxTitle : 'Propriedades da Caixa de Verificação',
		radioTitle	: 'Propriedades do Botão de Opção',
		value		: 'Valor',
		selected	: 'Seleccionado'
	},

	// Form Dialog.
	form :
	{
		title		: 'Propriedades do Formulário',
		menu		: 'Propriedades do Formulário',
		action		: 'Acção',
		method		: 'Método',
		encoding	: 'Encoding' // MISSING
	},

	// Select Field Dialog.
	select :
	{
		title		: 'Propriedades da Caixa de Combinação',
		selectInfo	: 'Informação',
		opAvail		: 'Opções Possíveis',
		value		: 'Valor',
		size		: 'Tamanho',
		lines		: 'linhas',
		chkMulti	: 'Permitir selecções múltiplas',
		opText		: 'Texto',
		opValue		: 'Valor',
		btnAdd		: 'Adicionar',
		btnModify	: 'Modificar',
		btnUp		: 'Para cima',
		btnDown		: 'Para baixo',
		btnSetValue : 'Definir um valor por defeito',
		btnDelete	: 'Apagar'
	},

	// Textarea Dialog.
	textarea :
	{
		title		: 'Propriedades da Área de Texto',
		cols		: 'Colunas',
		rows		: 'Linhas'
	},

	// Text Field Dialog.
	textfield :
	{
		title		: 'Propriedades do Campo de Texto',
		name		: 'Nome',
		value		: 'Valor',
		charWidth	: 'Tamanho do caracter',
		maxChars	: 'Nr. Máximo de Caracteres',
		type		: 'Tipo',
		typeText	: 'Texto',
		typePass	: 'Palavra-chave'
	},

	// Hidden Field Dialog.
	hidden :
	{
		title	: 'Propriedades do Campo Escondido',
		name	: 'Nome',
		value	: 'Valor'
	},

	// Image Dialog.
	image :
	{
		title		: 'Propriedades da Imagem',
		titleButton	: 'Propriedades do Botão de imagens',
		menu		: 'Propriedades da Imagem',
		infoTab		: 'Informação da Imagem',
		btnUpload	: 'Enviar para o Servidor',
		upload		: 'Carregar',
		alt			: 'Texto Alternativo',
		lockRatio	: 'Proporcional',
		resetSize	: 'Tamanho Original',
		border		: 'Limite',
		hSpace		: 'Esp.Horiz',
		vSpace		: 'Esp.Vert',
		alertUrl	: 'Por favor introduza o URL da imagem',
		linkTab		: 'Hiperligação',
		button2Img	: 'Deseja transformar o botão com imagem selecionado em uma imagem?',
		img2Button	: 'Deseja transformar a imagem selecionada em um botão com imagem?',
		urlMissing	: 'O URL da fonte da imagem está em falta.',
		validateBorder	: 'A borda tem de ser um numero.', 
		validateHSpace	: 'HSpace tem de ser um numero.',
		validateVSpace	: 'VSpace tem de ser um numero.'
	},

	// Flash Dialog
	flash :
	{
		properties		: 'Propriedades do Flash',
		propertiesTab	: 'Propriedades',
		title			: 'Propriedades do Flash',
		chkPlay			: 'Reproduzir automaticamente',
		chkLoop			: 'Loop',
		chkMenu			: 'Permitir Menu do Flash',
		chkFull			: 'Permitir Ecrã inteiro',
 		scale			: 'Escala',
		scaleAll		: 'Mostrar tudo',
		scaleNoBorder	: 'Sem Limites',
		scaleFit		: 'Tamanho Exacto',
		access			: 'Acesso ao Script',
		accessAlways	: 'Sempre',
		accessSameDomain: 'Mesmo dominio',
		accessNever		: 'Nunca',
		alignAbsBottom	: 'Abs inferior',
		alignAbsMiddle	: 'Abs centro',
		alignBaseline	: 'Linha de base',
		alignTextTop	: 'Topo do texto',
		quality			: 'Qualidade',
		qualityBest		: 'Melhor', 
		qualityHigh		: 'Alta',
		qualityAutoHigh	: 'Alta Automaticamente',
		qualityMedium	: 'Média',
		qualityAutoLow	: 'Baixa Automaticamente',
		qualityLow		: 'Baixa',
		windowModeWindow: 'Janela',
		windowModeOpaque: 'Opaco',
		windowModeTransparent : 'Transparente',
		windowMode		: 'Modo de jnela',
		flashvars		: 'Variaveis para o Flash',
		bgcolor			: 'Cor de Fundo',
		hSpace			: 'Esp.Horiz',
		vSpace			: 'Esp.Vert',
		validateSrc		: 'Por favor introduza a hiperligação URL',
		validateHSpace	: 'HSpace tem de ser um numero.',
		validateVSpace	: 'VSpace tem de ser um numero.'
	},

	// Speller Pages Dialog
	spellCheck :
	{
		toolbar			: 'Verificação Ortográfica',
		title			: 'Verificação Ortográfica',
		notAvailable	: 'Desculpe, mas o serviço não está disponivel agora.',
		errorLoading	: 'Erro ao carregar o host do serviço da aplicação: %s.',
		notInDic		: 'Não está num directório',
		changeTo		: 'Mudar para',
		btnIgnore		: 'Ignorar',
		btnIgnoreAll	: 'Ignorar Tudo',
		btnReplace		: 'Substituir',
		btnReplaceAll	: 'Substituir Tudo',
		btnUndo			: 'Anular',
		noSuggestions	: '- Sem sugestões -',
		progress		: 'Verificação ortográfica em progresso…',
		noMispell		: 'Verificação ortográfica completa: não foram encontrados erros',
		noChanges		: 'Verificação ortográfica completa: não houve alteração de palavras',
		oneChange		: 'Verificação ortográfica completa: uma palavra alterada',
		manyChanges		: 'Verificação ortográfica completa: %1 palavras alteradas',
		ieSpellDownload	: ' Verificação ortográfica não instalada. Quer descarregar agora?'
	},

	smiley :
	{
		toolbar	: 'Emoticons',
		title	: 'Inserir um Emoticon',
		options : 'Opções dos Smiley'
	},

	elementsPath :
	{
		eleLabel : 'Elements path', // MISSING
		eleTitle : '%1 element' // MISSING
	},

	numberedlist	: 'Numeração',
	bulletedlist	: 'Marcas',
	indent			: 'Aumentar Avanço',
	outdent			: 'Diminuir Avanço',

	justify :
	{
		left	: 'Alinhar à Esquerda',
		center	: 'Alinhar ao Centro',
		right	: 'Alinhar à Direita',
		block	: 'Justificado'
	},

	blockquote : 'Bloco de citação',

	clipboard :
	{
		title		: 'Colar',
		cutError	: 'A configuração de segurança do navegador não permite a execução automática de operações de cortar. Por favor use o teclado (Ctrl/Cmd+X).',
		copyError	: 'A configuração de segurança do navegador não permite a execução automática de operações de copiar. Por favor use o teclado (Ctrl/Cmd+C).',
		pasteMsg	: 'Por favor, cole dentro da seguinte caixa usando o teclado (<STRONG>Ctrl/Cmd+V</STRONG>) e prima <STRONG>OK</STRONG>.',
		securityMsg	: 'Devido ás definições de segurança do teu browser, o editor não pode aceder ao clipboard diretamente. É necessário que voltes a colar as informações nesta janela.',
		pasteArea	: 'Paste Area' // MISSING
	},

	pastefromword :
	{
		confirmCleanup	: 'O texto que pretende colar parece ter sido copiado do Word. Deseja limpá-lo antes de colar?',
		toolbar			: 'Colar do Word',
		title			: 'Colar do Word',
		error			: 'Não foi possivel limpar a informação colada decido a um erro interno'
	},

	pasteText :
	{
		button	: 'Colar como Texto Simples',
		title	: 'Colar como Texto Simples'
	},

	templates :
	{
		button			: 'Modelos',
		title			: 'Modelo de Conteúdo',
		options : 'Opções do Modelo',
		insertOption	: 'Substituir conteúdos actuais',
		selectPromptMsg	: 'Por favor, seleccione o modelo a abrir no editor<br>(o conteúdo actual será perdido):',
		emptyListMsg	: '(Sem modelos definidos)'
	},

	showBlocks : 'Exibir blocos',

	stylesCombo :
	{
		label		: 'Estilo',
	    panelTitle	: 'Estilos de Formatação',
	    panelTitle1	: 'Estilos de Bloco',
	    panelTitle2	: 'Estilos de Linha',
	    panelTitle3	: 'Estilos de Objeto'
	},

	format :
	{
		label		: 'Formato',
		panelTitle	: 'Formato',

		tag_p		: 'Normal',
		tag_pre		: 'Formatado',
		tag_address	: 'Endereço',
		tag_h1		: 'Título 1',
		tag_h2		: 'Título 2',
		tag_h3		: 'Título 3',
		tag_h4		: 'Título 4',
		tag_h5		: 'Título 5',
		tag_h6		: 'Título 6',
		tag_div		: 'Normal (DIV)' // MISSING
	},

	div :
	{
		title				: 'Criar Div',
		toolbar				: 'Criar Div',
		cssClassInputLabel	: 'Classes de Estilo de Folhas de Classe',
		styleSelectLabel	: 'Estilo',
		IdInputLabel		: 'Id',
		languageCodeInputLabel	: ' Codigo do Idioma',
		inlineStyleInputLabel	: 'Estilho em linha',
		advisoryTitleInputLabel	: 'Título',
		langDirLabel		: 'Orientação de idioma',
		langDirLTRLabel		: 'Da Esquerda para a Direita (LTR)',
		langDirRTLLabel		: 'Da Direita para a Esquerda (RTL)',
		edit				: 'Editar Div',
		remove				: 'Remover Div'
  	},

	iframe :
	{
		title		: 'Propriadades da IFrame ',
		toolbar		: 'IFrame',
		noUrl		: 'Por favor escreva o URL da iframe',
		scrolling	: 'Activar barras de deslocamento',
		border		: 'Mostrar a borda da Frame'
	},

	font :
	{
		label		: 'Tipo de Letra',
		voiceLabel	: 'Letra',
		panelTitle	: 'Tipo de Letra'
	},

	fontSize :
	{
		label		: 'Tamanho',
		voiceLabel	: 'Tamanho da letra',
		panelTitle	: 'Tamanho'
	},

	colorButton :
	{
		textColorTitle	: 'Cor do Texto',
		bgColorTitle	: 'Cor de Fundo',
		panelTitle		: 'Cores',
		auto			: 'Automático',
		more			: 'Mais Cores...'
	},

	colors :
	{
		'000' : 'Black', // MISSING
		'800000' : 'Maroon', // MISSING
		'8B4513' : 'Saddle Brown', // MISSING
		'2F4F4F' : 'Dark Slate Gray', // MISSING
		'008080' : 'Teal', // MISSING
		'000080' : 'Navy', // MISSING
		'4B0082' : 'Indigo', // MISSING
		'696969' : 'Dark Gray', // MISSING
		'B22222' : 'Fire Brick', // MISSING
		'A52A2A' : 'Brown', // MISSING
		'DAA520' : 'Golden Rod', // MISSING
		'006400' : 'Dark Green', // MISSING
		'40E0D0' : 'Turquoise', // MISSING
		'0000CD' : 'Medium Blue', // MISSING
		'800080' : 'Purple', // MISSING
		'808080' : 'Gray', // MISSING
		'F00' : 'Red', // MISSING
		'FF8C00' : 'Dark Orange', // MISSING
		'FFD700' : 'Gold', // MISSING
		'008000' : 'Green', // MISSING
		'0FF' : 'Cyan', // MISSING
		'00F' : 'Blue', // MISSING
		'EE82EE' : 'Violet', // MISSING
		'A9A9A9' : 'Dim Gray', // MISSING
		'FFA07A' : 'Light Salmon', // MISSING
		'FFA500' : 'Orange', // MISSING
		'FFFF00' : 'Yellow', // MISSING
		'00FF00' : 'Lime', // MISSING
		'AFEEEE' : 'Pale Turquoise', // MISSING
		'ADD8E6' : 'Light Blue', // MISSING
		'DDA0DD' : 'Plum', // MISSING
		'D3D3D3' : 'Light Grey', // MISSING
		'FFF0F5' : 'Lavender Blush', // MISSING
		'FAEBD7' : 'Antique White', // MISSING
		'FFFFE0' : 'Light Yellow', // MISSING
		'F0FFF0' : 'Honeydew', // MISSING
		'F0FFFF' : 'Azure', // MISSING
		'F0F8FF' : 'Alice Blue', // MISSING
		'E6E6FA' : 'Lavender', // MISSING
		'FFF' : 'White' // MISSING
	},
	scayt : 
	{
	    title 			: 'Verificaçao Ortográfica',
	    opera_title 	: 'Não é suportado pelo Opera',
		enable 			: 'Activar SCAYT',
		disable 		: 'Desativar SCAYT',
	    about 			: 'Sobre o SCAYT',
	    toggle 			: 'Comutar SCAYT',
	    options 		: 'Opções',
	    langs 			: 'Idiomas',
	    moreSuggestions : 'Mais sujetões',
	    ignore 			: 'Ignorar',
	    ignoreAll 		: 'Ignorar Todos',
	    addWord 		: 'Adicionar Palavra',
	    emptyDic 		: 'O nome do dicionário não deve estar vazio.',
		noSuggestions	: 'Sem sujestão',
	    optionsTab 		: 'Opções',
		allCaps 		: 'Ignorar todas as palavras em Caps Lock',
	    ignoreDomainNames : 'Ignorar Nomes de Dominio',
	    mixedCase 		: 'Ignorar Palavas com letras Grandes e Pequenas',
	    mixedWithDigits : 'Ignorar Palavras com Numeros',

	    languagesTab 	: 'Idiomas',

	    dictionariesTab : 'Dicionários',
	    dic_field_name 	: 'Nome do dicionário',
	    dic_create 		: 'Criar',
	    dic_delete 		: 'Eliminar',
	    dic_restore 	: 'Restaurar',
	    dic_rename 		: 'Renomear',
	    dic_info 		: 'Inicialmente o dicionário do utilizador é guardado em uma Cookie. No entanto, as Cookies são limitadas limitadas no tamanho. Quando um dicionário de utilizador cresce ao ponto de não poder ser guadadoem uma Cookie, o dicionário é então guardado nos nossos servidores. Para guardar o seu dicionário nos nossos servidores deve especificar um nome para o dicionário. Se voçe já guardou um dicionário, escreva o nome dele e clique em Restaurar.',
	    
	    aboutTab 		: 'Sobre'
	},
	

	about :
	{
		title		: 'Sobre o CKEditor',
		dlgTitle	: 'Sobre o CKEditor',
		help	: 'Doar $1 para ajudar.',
		userGuide : 'Guia de utilizador do CKEditor',
		moreInfo	: 'Para informações sobre licenciamento visite o nosso website:',
		copy		: 'Copyright &copy; $1. Todos os direitos reservados.'
	},

	maximize : 'Maximizar',
	minimize : 'Minimizar',

	fakeobjects :
	{
		anchor		: 'Âncora',
		flash		: 'Animação Flash',
		iframe		: 'IFrame',
		hiddenfield	: 'Campo Oculto',
		unknown		: 'Objeto desconhecido' 
	},

	resize : 'Arraste para redimensionar',

	colordialog :
	{
		title		: 'Select color', // MISSING
		options	:	'Color Options', // MISSING
		highlight	: 'Highlight', // MISSING
		selected	: 'Selected Color', // MISSING
		clear		: 'Clear' // MISSING
	},

	toolbarCollapse	: 'Colapsar Barra',
	toolbarExpand	: 'Expandir Barra',

	toolbarGroups :
	{
		document : 'Document', // MISSING
		clipboard : 'Clipboard/Undo', // MISSING
		editing : 'Editing', // MISSING
		forms : 'Forms', // MISSING
		basicstyles : 'Basic Styles', // MISSING
		paragraph : 'Paragraph', // MISSING
		links : 'Links', // MISSING
		insert : 'Insert', // MISSING
		styles : 'Styles', // MISSING
		colors : 'Colors', // MISSING
		tools : 'Tools' // MISSING
	},

	bidi :
	{
		ltr : 'Direção do texto da esquerda para a direita',
		rtl : 'Direção do texto da direita para a esquerda'
	},

	docprops :
	{
		label : 'Propriedades do Documento',
		title : 'Propriedades do Documento',
		design : 'Design',
		meta : 'Meta Data',
		chooseColor : 'Escolher',
		other : '<outro>',
		docTitle :	'Título da Página',
		charset : 	'Codificação de Caracteres',
		charsetOther : 'Outra Codificação de Caracteres',
		charsetASCII : 'ASCII',
		charsetCE : 'Central European', // MISSING
		charsetCT : 'Chinese Traditional (Big5)', // MISSING
		charsetCR : 'Cyrillic', // MISSING
		charsetGR : 'Greek', // MISSING
		charsetJP : 'Japanese', // MISSING
		charsetKR : 'Korean', // MISSING
		charsetTR : 'Turkish', // MISSING
		charsetUN : 'Unicode (UTF-8)', // MISSING
		charsetWE : 'Western European', // MISSING
		docType : 'Tipo de Cabeçalho do Documento',
		docTypeOther : 'Outro Tipo de Cabeçalho do Documento',
		xhtmlDec : 'Incluir Declarações XHTML',
		bgColor : 'Cor de Fundo',
		bgImage : 'Caminho para a Imagem de Fundo',
		bgFixed : 'Fundo Fixo',
		txtColor : 'Cor do Texto',
		margin : 'Margem das Páginas',
		marginTop : 'Topo',
		marginLeft : 'Esquerda',
		marginRight : 'Direita',
		marginBottom : 'Fundo',
		metaKeywords : 'Palavras de Indexação do Documento (separadas por virgula)',
		metaDescription : 'Descrição do Documento',
		metaAuthor : 'Autor',
		metaCopyright : 'Direitos de Autor',
		previewHtml : '<p>This is some <strong>sample text</strong>. You are using <a href="javascript:void(0)">CKEditor</a>.</p>' // MISSING
	}
};
