/**
 * A plugin to insert nbsp when hitting CTRL Space 
 */
(function()
{
	CKEDITOR.plugins.add( 'en_nbsp',
	{				
		init: function( editor )
		{	
			editor.on( 'contentDom', function( e )
			{
				var editable = e.editor.editable();		
				var doc = editor.document;
				editable.attachListener( doc, 'keydown', function( ev )
				{					
					if ( ev.data.getKeystroke() === CKEDITOR.CTRL + 32 ) // CTRL + SPACE							
					{		
							ev.data.preventDefault();
							editor.insertHtml( '&nbsp;' );
					}			
				});
			});	
		}
	});
})();