(function() {
	CKEDITOR.plugins.add( 'customPlugin', {
		lang: 'ar,bg,ca,cs,cy,de,el,en,eo,es,et,eu,fa,fi,fr,fr-ca,gl,he,hr,hu,id,it,ja,ko,ku,lv,nb,nl,no,pl,pt,pt-br,ru,si,sk,sl,sq,sv,tr,ug,uk,vi,zh-cn',
		onLoad: function()
		{
			CKEDITOR.addCss( 'img.cke_customPlugin1' +
				'{' +
					'background-color: gray;' +
					'background-position: center center;' +
					'background-repeat: no-repeat;' +
					'border: 1px solid blue;' +
					'min-width: 50px;' +
					'min-height: 50px;' +
				'}'
			);

			CKEDITOR.addCss( 'img.cke_customPlugin2' +
				'{' +
					'background-color: gray;' +
					'background-position: center center;' +
					'background-repeat: no-repeat;' +
					'border: 1px solid red;' +
					'min-width: 50px;' +
					'min-height: 50px;' +
				'}'
			);
		},
		afterInit: function( editor )
		{
			var dataProcessor = editor.dataProcessor,
				dataFilter = dataProcessor && dataProcessor.dataFilter;

			if( dataFilter )
			{
				dataFilter.addRules(
				{
					elements: {
						'div': function( element )
						{
							if( element.attributes['class'] == 'customPlugin1' )
								return editor.createFakeParserElement( element, 'cke_customPlugin1', 'customPlugin1', true );
							else if( element.attributes['class'] == 'customPlugin2' )
								return editor.createFakeParserElement( element, 'cke_customPlugin2', 'customPlugin2', false );

							return null;
						}
					}
				}, 5 );
			}
		}
	});
})();