/**
 * @license Copyright (c) 2003-2013, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.html or http://ckeditor.com/license
 */

CKEDITOR.editorConfig = function( config ) {

	config.toolbar_Full =
	[
		['Undo','Redo','-','Find','Replace'],
		['Bold','Italic','Underline','Strike','Subscript','Superscript'],
		['JustifyLeft','JustifyCenter','JustifyRight','JustifyBlock'],
		['Link','Unlink','Anchor','Image','Flash'],
		['Scayt', 'Maximize', 'Print'],
		'/',
		['Cut','Copy','Paste','PasteText','PasteFromWord', 'RemoveFormat'],
		['TextColor','BGColor'],
		['NumberedList','BulletedList','Outdent','Indent','Blockquote'],
		['Table','HorizontalRule','SpecialChar','PageBreak'],
		['Source'],
		'/',
		['Font','FontSize','Format']
	];

	config.toolbar_Basic =
	[
		['Undo','Redo'],
		['Bold','Italic','Strike','Underline'],
		['JustifyLeft','JustifyCenter','JustifyRight','JustifyBlock'],
		['Link','Unlink','Image'],
		['MediaEmbed','SpecialChar'],
		['Scayt', 'Maximize'],
		'/',
		['Format','TextColor','FontSize'],
		['PasteText','PasteFromWord', 'RemoveFormat'],
		['NumberedList','BulletedList','Outdent','Indent','-','Blockquote'],
		['Source']
	];

	config.toolbar_Posts =
	[
		['Undo','Redo'],
		['Bold','Italic','Strike','Underline'],
		['JustifyLeft','JustifyCenter','JustifyRight','JustifyBlock'],
		['Link','Unlink','Image','WPMore'],
		['Scayt', 'Maximize'],
		'/',
		['Format','TextColor'],
		['PasteText','PasteFromWord', 'RemoveFormat'],
		['MediaEmbed','SpecialChar'],
		['NumberedList','BulletedList','Outdent','Indent','-','Blockquote'],
		['Source']
	];

	config.toolbar_Email =
	[
		['Undo','Redo'],
		['Bold','Italic','Strike','Underline'],
		['JustifyLeft','JustifyCenter','JustifyRight','JustifyBlock'],
		['Link','Unlink','Image'],
		['people_fields'],
		'/',
		['PasteText','PasteFromWord', 'RemoveFormat'],
		['TextColor','MediaEmbed','SpecialChar','FontSize'],
		['NumberedList','BulletedList','Outdent','Indent'],
		['Scayt', 'Maximize'],
		['Source']
	];

	config.toolbar_Sidebar =
	[
		['Undo','Redo'],
		['Bold','Italic','Strike','Underline'],
		['JustifyLeft','JustifyCenter','JustifyRight','JustifyBlock'],
		['Link','Unlink','Image'],
		['Scayt', 'Maximize'],
		'/',
		['Format','TextColor'],
		['PasteText','PasteFromWord', 'RemoveFormat'],
		['MediaEmbed','SpecialChar'],
		['NumberedList','BulletedList','Outdent','Indent','-','Blockquote'],
		['Source']
	];

	config.dialog_backgroundCoverColor = '#000000';
	//config.scayt_autoStartup = true;
	config.format_tags = 'p;div;h1;h2;h3';
	config.removeDialogTabs = 'image:advanced;link:advanced';

	config.extraAllowedContent =  {
		style: {
			attributes: 'type'
		},
		'h1 h2 h3 p blockquote strong em a span ul big small table th td' : {
			styles: 'color,font-weight,font-family,font-size,text-align,line-height,text-decoration'
		},
		a: {
			attributes: '!href,target'
		},
		img: {
			attributes: '!src,alt,width,height,border',
			styles: 'width,height,border,text-decoration'
		},
		'table th td' : {
			styles: 'width,height,margin,margin-top,margin-right,margin-bottom,margin-left,padding,padding-top,padding-right,padding-bottom,padding-left,background-color,border-collapse'
		},
		table: {
			attributes: 'width,height,align,border,cellpadding,cellspacing,summary,bgcolor'
		},
		'caption tbody thead tfoot' : true,
		tr: {},
		'th td': {
			attributes: 'width,height,scope,align,valign,colspan,rowspan,bgcolor'
		},
		'del ins': true
	};

};