/**
 * Widgets éditoriaux pour CKEditor.
 *
 * Voir ressources :
 * http://docs.ckeditor.com/#!/guide/widget_sdk_tutorial_1
 * http://docs.ckeditor.com/#!/guide/widget_sdk_tutorial_2
 * https://github.com/ckeditor/ckeditor-docs-samples/tree/master/tutorial-simplebox-2
 */


CKEDITOR.plugins.add('helloworld', {
  requires: 'widget',
  icons: 'helloworld',

  init: function(editor) {

     /**
     * Widget 'Hello world'.
     */
  CKEDITOR.dialog.add('helloworld', this.path + 'dialogs/helloworld.js');
    editor.ui.addButton('helloworld', {
      label : 'Hello world',
      command : 'helloworld'
    });
    editor.widgets.add('helloworld', {
      allowedContent: 'p',
      requiredContent: 'p',
      styleableElements: 'p',
      template: '<p class="helloworld"></p>',
      dialog: 'helloworld',
      mask: true,
      

      parts: {
        content: 'p.helloworld'
      },

      data: function() {
        var newData = this.data,
          oldData = this.oldData;
        if ( newData.text )
          this.parts.content.setHtml( newData.text );

        // Save oldData.
        this.oldData = CKEDITOR.tools.copy( newData );
      },

      upcast: function( el ) {
        if (el.hasClass('helloworld')) {
          return el;
        }
      },

      downcast: function( el ) {
        if (el.hasClass('helloworld')) {
          return el;
        }
      }
    });
  }

});

