 
/**
 * Boite de dialogue pour widgets éditoriaux.
 *
 * Voir ressources :
 * http://docs.ckeditor.com/#!/api/CKEDITOR.dialog.definition
 */

CKEDITOR.dialog.add('helloworld', function(editor) {

  // Size adjustments.
  var size = CKEDITOR.document.getWindow().getViewPaneSize(),
    clientHeight = document.documentElement.clientHeight,
  // Make it maximum 800px wide, but still fully visible in the viewport.
    width = Math.min( size.width - 70, 800 ),
  // Make it use 2/3 of the viewport height.
    height = size.height / 1.5;
  // Low resolution settings.
  if ( clientHeight < 650 )
    height = clientHeight - 220;


  return {
    title: 'Hello world message',
    minHeight: 200,
    resizable: CKEDITOR.DIALOG_RESIZE_NONE,
    contents: [
      {
        id: 'info',
        elements: [
          {
            id: 'text',
            type: 'textarea',
            setup: function( widget ) {
              this.setValue( widget.data.text );
            },
            commit: function( widget ) {
              widget.setData( 'text', this.getValue() );
            },
            required: true,
            inputStyle: 'cursor:auto;' +
              'width:' + width + 'px;' +
              'height:' + height + 'px;' +
              'tab-size:4;' +
              'text-align:left;',
            'class': 'cke_source'
          }
        ]
      }
    ]
  };
});
