/**
 * @license Copyright (c) 2003-2013, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.html or http://ckeditor.com/license
 */

 CKEDITOR.editorConfig = function( config ) {
    
    config.toolbarGroups = [
        { name: 'clipboard', groups: [ 'clipboard', 'undo' ] }, { name: 'editing', groups: [ 'find', 'selection', 'spellchecker' ] }, '/', { name: 'basicstyles', groups: [ 'basicstyles', 'cleanup' ] }, { name: 'document', groups: [ 'mode', 'document', 'doctools' ] }, '/', { name: 'styles' }, { name: 'insert' }
    ];

    //Remove some buttons, provided by the standard plugins, which we don't need to have in the Standard(s) toolbar. 
	config.removeButtons = 'NewPage,Templates,CreateDiv,Anchor,Flash,Image,HorizontalRule,Smiley,PageBreak,Iframe,Format,Font,FontSize,Table';

    //remove overall plugins that no need 
	config.removePlugins = 'document,forms,about'

    //Make dialogs simpler. 
	config.removeDialogTabs = 'image:advanced;link:advanced';

    //To set the Undo Stack size to hold (N-1)
    config.undoStackSize = 500;

};

