'use strict';

var D = {
	logNode: function( node ) {
		if ( node.nodeType )
			node = new CKEDITOR.dom.node( node );

		if ( node.type == CKEDITOR.NODE_ELEMENT ) {
			var clone = node.clone();

			if ( !node.is( CKEDITOR.dtd.$empty ) )
				clone.setText( '...' );

			return clone.getOuterHtml();
		} else if ( node.type == CKEDITOR.NODE_TEXT )
			return '"' + node.getText() + '"';
		else if ( !node )
			return 'NO NODE';

		return 'UNKNOWN';
	},

	logSelection: function( sel ) {
		if ( !sel )
			return '{ NO SELECTION }';

		var out = [];

		out.push( '{\n' );
		out.push( '	startElement: ' + this.logNode( sel.getStartElement() ) );
		out.push( ',\n' );
		out.push( '	isFake: ' + ( sel.isFake ? 'FAKE' : 'NO' ) );
		out.push( ',\n' );
		out.push( '	isHidden: ' + ( sel.isHidden() ? 'HIDDEN' : 'NO' ) );
		out.push( ',\n' );
		out.push( '	range: ' + this.logRange( sel.getRanges()[ 0 ] ) );
		out.push( ',\n' );
		out.push( '	native: ' + this.logNativeSelection( sel.document.getWindow().$.getSelection() ) );
		out.push( '\n}' );
		return out.join( '' );
	},

	logNativeSelection: function( nat ) {
		var out = [];

		out.push( '{\n' );
		out.push( '		anchorNode: ' + this.logNode( nat.anchorNode ) );
		out.push( '\n	}' );

		return out.join( '' );
	},

	logRange: function( range ) {
		if ( !range )
			return '{ NO RANGE }';

		var out = [];

		out.push( '{\n' );
		out.push( '		startContainer: ' + this.logNode( range.startContainer ) );
		out.push( ',\n' );
		out.push( '		startOffset: ' + range.startOffset );
		out.push( ',\n' );
		out.push( '		endContainer: ' + this.logNode( range.endContainer ) );
		out.push( ',\n' );
		out.push( '		endOffset: ' + range.endOffset );
		out.push( ',\n' );
		out.push( '		collapsed: ' + ( range.collapsed ? 'COLLAPSED' : 'NO' ) );
		out.push( '\n	}' );

		return out.join( '' );
	},

	getSelection: function( editor ) {
		var that = this;

		console.log( 'You got 2s to select sth...' );

		setTimeout( function() {
			var sel = new CKEDITOR.dom.selection( editor.editable() );

			console.log( 'Selection:', that.logSelection( sel ) );
			console.log( 'Native:', editor.window.$.getSelection() );
		}, 2000 );
	},

	getNativeSelection: function( window ) {
		console.log( 'You got 2s to select sth...' );

		setTimeout( function() {
			console.log( 'Native selection:', window.getSelection() );
		}, 2000 );
	}
};