<?php

class com_wiris_plugin_impl_EditorImpl implements com_wiris_plugin_api_Editor{
	public function __construct($plugin) {
		if(!php_Boot::$skip_constructor) {
		$this->plugin = $plugin;
	}}
	public function editor($language, $prop) {
		$output = new StringBuf();
		if($language === null || strlen($language) === 0) {
			$language = "en";
		}
		$language = strtolower($language);
		str_replace("-", "_", $language);
		$store = com_wiris_system_Storage::newResourceStorage("lang/" . $language . "/strings.js");
		if(!$store->exists()) {
			$store = com_wiris_system_Storage::newResourceStorage("lang/" . _hx_substr($language, 0, 2) . "/strings.js");
			$language = _hx_substr($language, 0, 2);
			if(!$store->exists()) {
				$language = "en";
			}
		}
		$attributes = new StringBuf();
		$attributes->add("");
		$confVal = "";
		$i = 0;
		$config = $this->plugin->getConfiguration();
		$h = com_wiris_plugin_api_ConfigurationKeys::$imageConfigProperties;
		$it = $h->keys();
		$value = null;
		while($it->hasNext()) {
			$value = $it->next();
			if($config->getProperty($value, null) !== null) {
				if($i !== 0) {
					$attributes->add(",");
				} else {
					$i++;
				}
				$confVal = $config->getProperty($value, null);
				str_replace("-", "_", $confVal);
				str_replace("-", "_", $confVal);
				$attributes->add("'");
				$attributes->add($value);
				$attributes->add("' : '");
				$attributes->add($confVal);
				$attributes->add("'");
			}
		}
		if($i > 0) {
			$script = new StringBuf();
			$script->add("<script type=\"text/javascript\">window.wrs_attributes = {");
			$script->add($attributes);
			$script->add("};</script>");
		}
		$editorUrl = $this->plugin->getImageServiceURL("editor");
		$isSegure = com_wiris_system_PropertiesTools::getProperty($prop, "secure", "false") === "true";
		if(StringTools::startsWith($editorUrl, "http:") && $isSegure) {
			$editorUrl = "https:" . _hx_substr($editorUrl, 5, null);
		}
		$output->add("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">");
		$output->add("<html><head>");
		$output->add("<meta http-equiv=\"content-type\" content=\"text/html; charset=UTF-8\"/>");
		$output->add($attributes);
		$output->add("<script type=\"text/javascript\" src=\"" . $editorUrl . "?lang=" . rawurlencode($language) . "\"></script>");
		$output->add("<script type=\"text/javascript\" src=\"../core/editor.js\"></script>");
		$output->add("<script type=\"text/javascript\" src=\"../lang/" . rawurlencode($language) . "/strings.js\"></script>");
		$output->add("<title>WIRIS editor</title>");
		$output->add("<style type=\"text/css\">/*<!--*/html, body, #container { height: 100%; } body { margin: 0; }");
		$output->add("#links { text-align: right; margin-right: 20px; } #links_rtl {text-align: left; margin-left: 20px;} #controls { float: left; } #controls_rtl {float: right;}/*-->*/</style>");
		$output->add("</head><body topmargin=\"0\" leftmargin=\"0\" marginwidth=\"0\" marginheight=\"0\">");
		$output->add("<div id=\"container\"><div id=\"editorContainer\"></div><div id=\"controls\"></div>");
		$output->add("<div id=\"links\"><a href=\"http://www.wiris.com/editor3/docs/manual/latex-support\" id=\"a_latex\" target=\"_blank\">LaTeX</a> | ");
		$output->add("<a href=\"http://www.wiris.com/editor3/docs/manual\" target=\"_blank\" id=\"a_manual\">Manual</a></div></div></body>");
		return $output->b;
	}
	public $plugin;
	public function __call($m, $a) {
		if(isset($this->$m) && is_callable($this->$m))
			return call_user_func_array($this->$m, $a);
		else if(isset($this->dynamics[$m]) && is_callable($this->dynamics[$m]))
			return call_user_func_array($this->dynamics[$m], $a);
		else if('toString' == $m)
			return $this->__toString();
		else
			throw new HException('Unable to call '.$m.'');
	}
	function __toString() { return 'com.wiris.plugin.impl.EditorImpl'; }
}
