Code segment to replace the ContentsCss property in CKEditorControl.cs:

		[PersistenceMode(PersistenceMode.Attribute)]
		[Category("CKEditor Basic Settings")]
		[Description("The CSS file(s) to be used to apply style to the contents. It should reflect the CSS used in the final pages where the contents are to be used.  Comma, '|', CR, or LF separated list of files.")]
		[DefaultValue("~/ckeditor/contents.css")]
		[Editor(typeof(System.ComponentModel.Design.MultilineStringEditor), typeof(System.Drawing.Design.UITypeEditor))]
		public string ContentsCss
		{
			get
			{
				string retVal = string.Empty;
				foreach (string item in config.contentsCss) retVal += item + ",";
				if (retVal.EndsWith(",")) retVal = retVal.Remove(retVal.Length - 1);
				return retVal;
			}
			set { 
                config.contentsCss = value.Replace("\t", string.Empty).Split(new char[] { ',', '\n', '\r', '|' }, StringSplitOptions.RemoveEmptyEntries);
                for (int i = 0; i < config.contentsCss.Length; i++)
                {
                    if (config.contentsCss[i].StartsWith("~")) {
                        config.contentsCss[i] = ResolveUrl(config.contentsCss[i]);
                    }
                }
            }
		}
