var magic_id = "__magic__";
var magic_img =
  "<img src='http://www.roxen.com/internal-roxen-roxen' " +
  "     style='width: 12px; padding: 0 2px'>";
var magic_specialchar =
  magic_img + "<span style='display: none'>" + magic_id + "</span>";


var ck_editor;


function bindUI()
{
  //  Fetch version strings
  document.getElementById("ck_vers").textContent = CKEDITOR.version;
  document.getElementById("ck_rev").textContent = CKEDITOR.revision;
  
  //  Create editor
  var config = {
    toolbarCanCollapse: false,
    language:           "en",
    resize_enabled:     false,
    height:             100,
    entities:           false,
    enterMode:          CKEDITOR.ENTER_DIV,
    toolbar:            "MyToolbar",
    allowedContent:     true,
    removePlugins:      "elementspath,magicline"
  };
  
  var toolbar_items = [ "Undo", "Redo", "-", "SpecialChar" ];
  config.toolbar_MyToolbar = [ { name: "main",
				 items: toolbar_items } ];
  
  var edEl = document.getElementById("richtext");
  ck_editor = CKEDITOR.appendTo(edEl, config, "");
  
  //  Add custom items to Special Chars dialog
  CKEDITOR.on("dialogDefinition", function (evt) {
      var dialogName = evt.data.name;
      var dialogDefinition = evt.data.definition;
      if (dialogName === "specialchar") {
	var chars = CKEDITOR.config.specialChars;
	chars.push( [ magic_specialchar, "Insert magic image" ] );
      }
    });
  
  //  Add hook to catch special character insertion
  ck_editor.on("dataReady", CKInstanceReady);
}


function CKInstanceReady(evt)
{
  ck_editor.on("insertText", CKInsertText);
}


function CKInsertText(evt)
{
  var txt = evt.data;
  if (txt && txt.indexOf(magic_id) === 0) {
    //  When we run the built-in handler has already received the raw
    //  insert string so we must replace it with our custom image. The
    //  easiest way that doesn't mess with selections etc is to simply
    //  execute an "undo" command since the original insertText() saves
    //  a snapshot. Our own inserted fragment will instead take its place
    //  on the undo stack.
    //
    //  The only problem with this trick is if the user has an empty
    //  undo stack when we start since the "undo" action might not yet
    //  be flagged as enabled. In that case we delay the execution just
    //  enough to get it in sync first.
    var cb = function() {
      ck_editor.execCommand("undo");
      ck_editor.insertHtml(magic_img);

      //  NOTE: If the statement above is changed to the following the
      //        cursor positioning behaves normally again:
      //
      //  ck_editor.insertHtml("[" + magic_img + "]");
    };
    if (ck_editor.undoManager.undoable()) {
      cb();
    } else {
      window.setTimeout(cb, 0);
    }
  }
}
