CKEDITOR.plugins.add( 'insertlabel',
{ 

	//For this plugin we need to be sure that the code from the "richcombo" plugin is loaded, 
	//as that's the real code that creates the dropdown element
	requires : [ 'richcombo' ],
 
    init : function( editor )
    {
		var config = editor.config,
		var combo = '',
		var lastValue; //<--last value placeholder
		
		editor.ui.addRichCombo( 'insertlabel',
		{
			label : "Insert Label",
			title :"Insert Label",
			className : 'cke_myclass',
						
			//Attributes for the dropdown float panel
			panel :
            {
                css : [ CKEDITOR.skin.getPath( 'editor' ) ].concat( config.contentsCss ),
				multiSelect : false
            },
			
			//Initializes the dropdown on first click
			init : function()
            {	
				combo = this;
				combo.startGroup( 'Insertion Labels' );
				// Loop over the Array, adding all items to the combo.
				for (var i = 0;  i < config.myLabels.length; i++)
				{					
					var tempArray = config.myLabels[i]
					//combo.add('value', 'html', 'text');									
					combo.add( tempArray[0], tempArray[1], tempArray[2] );					
				}
			},
			
			//Specifies action to be executed when user clicks on one of elements in the dropdown
			onClick : function( value )
			{        
				editor.focus();
				editor.fire( 'saveSnapshot' );
				editor.insertHtml(value);
				editor.fire( 'saveSnapshot' );
				
				lastValue = value; //save last value
				this.setValue( value ); // set value in dropdown
			},
			
			//Defines a callback function that is invoked when combo is created. 
			//In the below example function will be invoked when selection changes.
			onRender : function(){
				editor.on( 'selectionChange', function( ev ) { 
					this.setValue( lastValue );////<-- prevent changing values in dropdown on selection change
				}, this );
			}
			
			//reset: function(){ }
			
			//onOpen : function(){ }
		});
    } 
} );

//Extending the config object with myLabels property
CKEDITOR.config.myLabels = [ 
["[first_name]", "First Name", "First Name"],
["[last_name]", "Last Name", "Last Name"],
["[email]", "Email", "Email"]
];