CKEDITOR.plugins.add( 'jc_contentbox', {
    requires: 'widget',
    icons: 'contentbox',
    lang: 'en,de',
    init: function( editor ) {
        CKEDITOR.dialog.add( 'jc-contentbox-dialog', function( editor ) {
            return {
                title: editor.lang.jc_contentbox.dialog.title,
                minWidth: 200,
                minHeight: 100,
                contents: [
                    {
                        id: 'info',
                        elements: [
                            {
                                id: 'align',
                                type: 'select',
                                label: editor.lang.jc_contentbox.dialog.align,
                                width: '100px',
                                items: [
                                    [ editor.lang.common.notSet, '' ],
                                    [ editor.lang.common.alignLeft, 'left' ],
                                    [ editor.lang.common.alignRight, 'right' ],
                                    [ editor.lang.common.alignCenter, 'center' ]
                                ],
                                setup: function( widget ) {
                                    this.setValue( widget.data.align );
                                },
                                commit: function( widget ) {
                                    widget.setData( 'align', this.getValue() );
                                }
                            },
                            {
                                id: 'width',
                                type: 'text',
                                label: editor.lang.jc_contentbox.dialog.width,
                                width: '100px',
                                setup: function( widget ) {
                                    this.setValue( widget.data.width );
                                },
                                commit: function( widget ) {
                                    widget.setData( 'width', this.getValue() );
                                }
                            }
                        ]
                    }
                ]
            };
        } );

        editor.widgets.add( 'contentbox', {
            allowedContent:'div(!jc-contentbox,align-left,align-right,align-center){width};',

            requiredContent: 'div(jc-contentbox)',

            editables: {
                content: '.jc-contentbox'
            },

            template: '<div class="jc-contentbox">' + editor.lang.jc_contentbox.content + '</div>',
            button: editor.lang.jc_contentbox.button,
            dialog: 'jc-contentbox-dialog',
            upcast: function( element ) {
                return element.name == 'div' && element.hasClass( 'jc-contentbox' );
            },
            init: function() {
                var width = this.element.getStyle( 'width' );
                if ( width ) {
                    this.setData( 'width', width );
                }
                if ( this.element.hasClass( 'align-left' ) ) {
                    this.setData( 'align', 'left' );
                }
                if ( this.element.hasClass( 'align-right' ) ) {
                    this.setData( 'align', 'right' );
                }
                if ( this.element.hasClass( 'align-center' ) ) {
                    this.setData( 'align', 'center' );
                }
            },
            data: function() {
                if ( !this.data.width ) {
                    this.element.removeStyle( 'width' );
                } else if ( /^\d+$/.test(this.data.width) ){
                    this.element.setStyle( 'width', this.data.width + 'px' );
                } else {
                    this.element.setStyle( 'width', this.data.width );
                }

                this.element.removeClass( 'align-left' );
                this.element.removeClass( 'align-right' );
                this.element.removeClass( 'align-center' );
                if ( this.data.align ) {
                    this.element.addClass( 'align-' + this.data.align );
                }
            }
        } );
    }
} );
