require 'cgi'

# = FCKeditor - The text editor for internet
# Copyright (C) 2003-2006 Frederico Caldeira Knabben
# 
# Licensed under the terms of the GNU Lesser General Public License:
# 		http://www.opensource.org/licenses/lgpl-license.php
# 
# For further information visit:
# 		http://www.fckeditor.net/
# 
# "Support Open Source software. What about a donation today?"
# 
# File Name: fckeditor.rb
# 	This is the integration file for Ruby.
# 	
# 	It defines the FCKeditor class that can be used to create editor
# 	instances in Ruby CGI on server side.
# 
# Author:: Kazuo Kohchi <kohchi@miyagino.net>
#
class FCKeditor
  BASE_PATH = '/fckeditor/'
  WIDTH = '100%'
  HEIGHT = '200'
  TOOLBAR_SET = 'Default'

  attr_accessor :BasePath, :Width, :Height, :ToolbarSet, :Value, :Config

  # == Constructor
  #
  # This is the constructor of FCKeditor class
  #
  # [_instanceName_] an instance name.
  #
  def initialize(instanceName)
    @InstanceName = instanceName
    @BasePath = BASE_PATH
    @Width = WIDTH
    @Height = HEIGHT
    @ToolbarSet	= TOOLBAR_SET
    @Value = ''

    @Config = {}
    @cgi = CGI.new
  end

  # == print created HTML page
  #
  # print the created HTML page on stdout.
  #
  def create; print createHtml; end

  # == create HTML string
  #
  # create HTML string and return it.
  #
  # [*return*] created HTML string
  #
  def createHtml
    _HtmlValue = CGI::escapeHTML(@Value)

    _Html = '<div>'

    if (isCompatible)
      _File = (@cgi.params['fcksource'][0] &&
        @cgi.params['fcksource'][0] == "true") ?
        'fckeditor.original.html' : 'fckeditor.html'

      _Link = "#{@BasePath}editor/#{_File}?InstanceName=#{@InstanceName}"
      _Link += "&amp;Toolbar=#{@ToolbarSet}" if (@ToolbarSet != '')

      # Render the linked hidden field.
      # Render the configurations hidden field.
      # Render the editor IFRAME.
      _Html += <<_EOF
<input type="hidden" id="#{@InstanceName}" 
    name="#{@InstanceName}" value="#{_HtmlValue}" style="display:none" />
<input type="hidden" id="#{@InstanceName}___Config" 
    value="#{getConfigFieldString}" style="display:none" />
<iframe id="#{@InstanceName}___Frame" src="#{_Link}" width="#{@Width}" 
    height="#{@Height}" frameborder="0" scrolling="no"></iframe>
_EOF
    else
      _WidthCSS = @Width =~ /%/ ? @Width : @Width + 'px'
      _HeightCSS = @Height =~ /%/ ? @Height : @Height + 'px'

      _Html += <<_EOF
<textarea name="#{@InstanceName}" rows="4" cols="40" 
    style="width: #{_WidthCSS}; height: #{_HeightCSS}">#{_HtmlValue}</textarea>
_EOF
    end

    _Html += '</div>'
  end

  # == check your browser
  #
  # whether your browser is compatible or not
  #
  # [*return*] return true if your browser is compatible. otherwise false.
  #
  def isCompatible
    sAgent = $HTTP_USER_AGENT ? $HTTP_USER_AGENT : @cgi.user_agent

    if (sAgent =~ /MSIE/ && sAgent !~ /mac/ && sAgent !~ /Opera/)
      iVersion = sAgent.sub(/^.+?MSIE (\d\.\d).+$/, '\1').to_f
      return iVersion >= 5.5 ? true : false
    elsif (sAgent =~ /Gecko\//)
      iVersion = sAgent.sub(/^.+?Gecko\/(\d{8}).+$/, '\1').to_i
      return iVersion >= 20030210 ? true : false
    end

    false
  end

  # == get the config field string
  #
  # get the config field string for hidden attribute of input element.
  #
  # [*return*] return encoded config field string
  #
  def getConfigFieldString
    sParams = ''
    bFirst = true

    @Config.each { |sKey, sValue|
      if (bFirst == false)
        sParams += '&amp;'
      else
        bFirst = false
      end

      if (sValue == 'true')
        sParams += encodeConfig(sKey) + '=true'
      elsif (sValue == 'false')
        sParams += encodeConfig(sKey) + '=false'
      else
        sParams += encodeConfig(sKey) + '=' + encodeConfig(sValue)
      end
    }

    sParams
  end

  # == encode config field string
  #
  # escape the config field string to URL encode and return it.
  #
  # [_valueToEncode_] original value string
  # [*return*] return escaped config field string
  #
  def encodeConfig(valueToEncode)
    valueToEncode.gsub(/&/, '%26').gsub(/=/, '%3D').gsub(/\"/, '%22')
  end
end
