<div style="width:100%; height: 400px; position: relative; background-color: rgb(229, 227, 223); overflow: hidden;" class="gmaps margin-bottom-40" id="map-canvas"></div>
<script>
var map;
var geocoder;
var midpoint = new google.maps.LatLng(28.1121487, 6.7589092);

var MY_MAPTYPE_ID = 'custom_style';

(function($) {
 geocoder = new google.maps.Geocoder();

  var featureOpts = [
    {
      stylers: [
            {
                "hue": "#2c3e50"
            },
            {
                "saturation": 250
            }
      ]
    },
    {
      elementType: 'labels',
      stylers: [
        { visibility: 'off' }
      ]
    },
    {
        "featureType": "road",
        "elementType": "geometry",
        "stylers": [
            {
                "lightness": 50
            },
            {
                "visibility": "simplified"
            }
        ]
    },
	    {
        "featureType": "road",
        "elementType": "labels",
        "stylers": [
            {
                "visibility": "off"
            }
        ]
    }
  ];

  var mapOptions = {
    zoom: 2,
    center: midpoint,
    mapTypeControlOptions: {
      mapTypeIds: [google.maps.MapTypeId.ROADMAP, MY_MAPTYPE_ID]
    },
    scrollwheel: false,
    navigationControl: false,
    mapTypeControl: false,
    scaleControl: false,
    mapTypeId: MY_MAPTYPE_ID,
	
  };

  map = new google.maps.Map(document.getElementById('map-canvas'),
      mapOptions);
  var styledMapOptions = {
    name: 'Custom Style'
  };

  var customMapType = new google.maps.StyledMapType(featureOpts, styledMapOptions);
  map.mapTypes.set(MY_MAPTYPE_ID, customMapType);

var locations = [
  {
    "address": 'Bank of Botswana, Gabarone, Botswana',
    "address_display":  '<strong>Bank of Botswana</strong>',
    "marker_url": "/members/botswana"
  },
];

  codeMemberLocations(locations);
    })(jQuery);


function placeMarker(locations, index) {
  if (index <= locations.length) {
    setTimeout(
      function() {
    geocoder.geocode( { 'address': locations[index].address }, function(results, status) {
    if (status == google.maps.GeocoderStatus.OK) {
      var marker = new google.maps.Marker({
          map: map,
          position: results[0].geometry.location,
          icon: locations[index].marker_icon == "" ? "": locations[index].marker_icon
      });
    var infowindow = new google.maps.InfoWindow({
      content: locations[index].address_display + (locations[index].marker_url == "" ? "" : '<br> <a href="'+locations[index].marker_url + '"> More... </a>')
    });
     marker.addListener('click', function() {infowindow.open(map,marker);});
     placeMarker(locations, index + 1);
    } else {
      placeMarker(locations, index);
   }
  });
      }, 50);
    }
}

function codeMemberLocations(locations) {
  placeMarker(locations, 0);
}

google.maps.event.addDomListener(window, 'load', initialize);

</script>