var ckSettings = {
  language: 'ru',
  // По-умолчанию обводить блоки красивыми рамочками
  startupOutlineBlocks: true,
  // Не использовать коды символов в верстке
  entities: false,
  // Вставлять содержимое буфера как обычный текст
  forcePasteAsPlainText: true,
  // Убрать лишние кнопочки из панелей
  removeButtons: 'Strike,Subscript,Superscript,Underline,Anchor,PasteText,' +
                 'Styles,SpecialChar,HorizontalRule,Table',
  // Основные блоковые элементы верстки (параграфы)
  format_tags: 'h2;h3;p',
  // Включаем плагин magicline
  magicline_everywhere: true,
  // По-возможности проверка орфографии средствами браузера
  disableNativeSpellChecker : false,
  // Семантические тэги для визуальных элементов оформления
  coreStyles_italic: { element: 'i', overrides: 'em' },
  coreStyles_bold: { element: 'b', overrides: 'strong' },
  // Количества доступных операций отмены действий
  undoStackSize: 30,
  // Плагины для разработчиков
  removePlugins: 'devtools,image,blockquote',
  // image2 автоматически отключает устаревший плагин image
  extraPlugins: 'image2,aside',
  // Какие панельки показывать
  toolbarGroups: [
    {name: 'styles'},
    {name: 'basicstyles', groups: ['basicstyles', 'cleanup']},
    {name: 'links'},
    {name: 'paragraph', groups: ['list', 'blocks']},
    {name: 'clipboard', groups: ['clipboard','undo']},
    {name: 'insert'},
    {name: 'tools', groups: ['tools']},
    {name: 'document', groups: ['mode', 'doctools']}
  ],
  image2_captionedClass: 'signed-image',

  // allow div classes and ids
  allowedContent: true,
  // disable content replacing when add template
  templates_replaceContent: false
};

CKEDITOR.plugins.addExternal( 'aside', '../../publications/ckeditor-plugins/aside/' );

/**
 * Диалог добавления изображений содержит ненужные поля
 */
CKEDITOR.on('dialogDefinition', function( ev ) {
  var dialogName = ev.data.name;
  var dialogDefinition = ev.data.definition;
  if (dialogName == 'image2') {
    var infoTab = dialogDefinition.getContents('info');
    infoTab.remove('width');
    infoTab.remove('height');
    infoTab.remove('lock');
    infoTab.remove('align');
  }
 });