/**
 * test for bug in image2
 */
/* global CKEDITOR */

(function() {
	'use strict';

	function getSelectedImage( editor, element ) {
		if (editor.widgets) {
			var widget = editor.widgets.focused;

			// hardcoded image2
			if ( widget && widget.name == 'image' ) {
				var el = widget.element;
				if (!el)
					return null;

				if (el.getName() == 'img')
					return el;

				var children = el.getElementsByTag('img');
				if (children.count() == 1)
					return children.getItem(0);

				return null; // failed!!!
			}
		}

		if (!element || !element.is( 'img' ) || (element.data && element.data( 'cke-realelement' )) || element.isReadOnly() )	// eslint-disable-line no-extra-parens
			return null;

		return element;
	}


	CKEDITOR.plugins.add( 'image2test', {
		icons: 'image2test', // %REMOVE_LINE_CORE%

		init : function( editor ) {
			var command =  {
				name : 'image2test',
				contextSensitive : true,

				exec: function( editor ) {
					alert('hi');
				},

				refresh: function( editor /*, path*/ ) {
					var img = getSelectedImage( editor );
					if ( !img ) {
						this.setState( CKEDITOR.TRISTATE_DISABLED );
						return;
					}

					this.setState( CKEDITOR.TRISTATE_ON );
				}
			};

			editor.addCommand( 'image2test', command );

			editor.ui.addButton( 'Test',
				{
					label : 'test',
					command : 'image2test',
					icon : this.path + 'icons/image2test.png',	// %REMOVE_LINE_CORE%
					toolbar: 'insert,10'
				} );
		}

	});


})();