/* global CKEDITOR */

CKEDITOR.dialog.add('bugplugin', function (editor) {
	'use strict';

	var plugin = CKEDITOR.plugins.bugplugin,
		dialogDefinition = {
			title: editor.lang.bugplugin.toolbar,
			minWidth: 330,
			minHeight: 330,
			contents: [{
				id: 'tab1',
				label: editor.lang.bugplugin.toolbar,
				title: editor.lang.bugplugin.toolbar,
				expand: true,
				padding: 0,
				elements: [{
					type: 'html',
					html: '<div><div>Testcase 1:<br/>Click in first input, type something, then press TAB, focus does not change</div><br/><div>Testcase 2:<br/>Click in third input, then press TAB, focus goes to wrong field</div><br/><input id="main1" placeholder="input1" style="border:1px solid #139ff7;margin:4px;padding:4px;"></div><div><input id="main2" placeholder="input2" style="border:1px solid #139ff7;margin:4px;padding:4px;"></div><div><input id="main3" placeholder="input3" style="border:1px solid #139ff7;margin:4px;padding:4px;"><br/><div>Issue seems to be that mouse clicks are not handled by CKE&apos;s focus manager, even though we are calling addFocusable()</div></div>'
				} ]
			}],
			buttons: [CKEDITOR.dialog.okButton, CKEDITOR.dialog.cancelButton],
			onLoad: function () {},
			onShow: function() {
				var dialog = CKEDITOR.dialog.getCurrent(),
					document = dialog.getElement().getDocument();
				dialog.addFocusable(document.getById('main3'), 1);
				dialog.addFocusable(document.getById('main2'), 1);
				dialog.addFocusable(document.getById('main1'), 1);
			},
			onOk: function() {}
		};

	return dialogDefinition;
});
