/* jshint devel: true, browser: true */
/* global require, CKEDITOR */

CKEDITOR.dialog.add('bugplugin', function (editor) {
	'use strict';

	var plugin = CKEDITOR.plugins.bugplugin,
		dialogDefinition = {
			title: editor.lang.bugplugin.toolbar,
			minWidth: 330,
			minHeight: 330,
			viewModel: {},
			contents: [{
				id: 'tab1',
				label: editor.lang.bugplugin.toolbar,
				title: editor.lang.bugplugin.toolbar,
				expand: true,
				padding: 0,
				elements: [{
					type: 'html',
					html: '<div><div>Testcase 1:<br/>Type something into the first input, then immediately (without tabbing) press OK. On IE11, he new value is not saved to the viewModel.</div><br/><input id="main1" placeholder="input1" data-bind="value: value1" style="border:1px solid #139ff7;margin:4px;padding:4px;"></div><div><input id="main2" placeholder="input2" data-bind="value: value2" style="border:1px solid #139ff7;margin:4px;padding:4px;"></div><div><input id="main3" placeholder="input3" data-bind="value: value3" style="border:1px solid #139ff7;margin:4px;padding:4px;"><br/><div>Could be related to Issue #14157, but this only reproduces on IE11, whereas that other issue is platform-independent</div></div>'
				} ]
			}],
			buttons: [CKEDITOR.dialog.okButton, CKEDITOR.dialog.cancelButton],
			onLoad: function () {
				require(['knockout'],
					function (ko) {
						var id = CKEDITOR.dialog.getCurrent().parts.contents.$.id,
							parent = document.getElementById(id);

						// initial ko observables
						dialogDefinition.viewModel = {
							value1: ko.observable('value1'),
							value2: ko.observable('value2'),
							value3: ko.observable('value3')
						};

						ko.applyBindings(dialogDefinition.viewModel, parent);
					});
			},
			onShow: function() {
				var dialog = CKEDITOR.dialog.getCurrent(),
					document = dialog.getElement().getDocument();
				dialog.addFocusable(document.getById('main3'), 1);
				dialog.addFocusable(document.getById('main2'), 1);
				dialog.addFocusable(document.getById('main1'), 1);
			},
			onOk: function() {
				// this.commitContent();

				alert(dialogDefinition.viewModel.value1() + ', ' + dialogDefinition.viewModel.value2() + ', ' + dialogDefinition.viewModel.value3());
			}
		};

	return dialogDefinition;
});
