CKEDITOR.plugins.add('hrcwidgetbootstrap', {
    requires: 'widget',
    icons: 'hrcwidgetbootstrapPanel',

    init: function(editor) {
        // Configurable Settings
         var allowedFull = editor.config.widgetbootstrap_allowedFull != undefined ? editor.config.widgetbootstrap_allowedFull :
            'p a div span h2 h3 h4 h5 h6 section article iframe object embed strong b i em cite pre blockquote small sub sup code ul ol li dl dt dd table thead tbody th tr td img caption mediawrapper br[href,src,target,width,height,colspan,span,alt,name,title,class,id,data-options]{text-align,float,margin}(*);'
       

        var showButtons = editor.config.widgetbootstrapShowButtons != undefined ? editor.config.widgetbootstrapShowButtons : true;

       
         editor.widgets.add('hrcwidgetbootstrapPanel', {
        	button: showButtons ? 'Add Panel' : undefined,
        	template:
             '<div class="panel panel-default">' +
                 '<div class="panel-heading">Enter Title Here</div>' +
                 '<div class="panel-body">Content Goes Here</div>' +
             '</div>',
            editables: {
            	col1: {
            		selector: '.panel-heading',
            		allowedContent: allowedFull
            	},
            	col2: {
            		selector: '.panel-body',
            		allowedContent: allowedFull
            	}
            },

            upcast: function( element ) {
                return element.name == 'div' && element.hasClass( 'panel-default' );
            }

        });


        // Append the widget's styles when in the CKEditor edit page,
        // added for better user experience.
        // Assign or append the widget's styles depending on the existing setup.
        if (typeof editor.config.contentsCss == 'object') {
            editor.config.contentsCss.push(CKEDITOR.getUrl(this.path + 'contents.css'));
        } else {
            editor.config.contentsCss = [editor.config.contentsCss, CKEDITOR.getUrl(this.path + 'contents.css')];
        }

    }
});
