/****************** CK Utilities *********************/
function CKRichEditor(configpath)
{
	this.id = null;
	this.editorInitialized = false;

	this.instantiate      = ckEditorInstantiate;
	this.maximize         = ckEditorMaximize;
	this.isReady = ckEditorIsReady;
	this.onLoad = ckEditorOnLoad;
	
	var editor = null;
	/* Instantiates a CKEditor instance. Input parameter 'textarea' is the textarea to be replaced by CKEditor*/
	function ckEditorInstantiate(textarea)
	{
		this.id = textarea;
		CKEDITOR.replace(textarea);
		var that = this;
		editor = CKEDITOR.instances[this.id];
		this.editor = editor;
		editor.on( 'instanceReady', function(){that.onLoad();});
	}

	/*Called when CKEditor is loaded*/
	function ckEditorOnLoad()
	{
		this.editorInitialized = true;
	}

	/*Maximizes the editor*/
	function ckEditorMaximize()
	{
		if(this.isReady())
			{try{editor.execCommand('maximize');}catch(error){};}
		else
		{
			var that = this;
			window.setTimeout(function(){that.maximize();},100);
		}
	}

	/*Indicates whether CKEditor is ready for interaction*/
	function ckEditorIsReady()
	{
		return this.editorInitialized;
	}

	/****************** CK Utilities End *****************/
}
