
// Register the plugin within the editor.
CKEDITOR.plugins.add('vp_accordion', {
	// This plugin requires the Widgets System defined in the 'widget' plugin.
	requires: 'widget',

	// The plugin initialization logic goes inside this method.
	init: function( editor ) {
		// Generate editables for 50 accordion items.
		var editables = {};
		for (var i=1; i < 50; i++) {
			editables['header' + i] = {
				selector: '.ui-accordion-header-' + i
			};
			editables['content' + i] = {
				selector: '.ui-accordion-content-' + i
			}
		}

		// Register the widget.
		editor.widgets.add('vp_accordion', {
			// Allow all HTML elements, classes, and styles that this widget requires.
			// Read more about the Advanced Content Filter here:
			// * http://docs.ckeditor.com/#!/guide/dev_advanced_content_filter
			// * http://docs.ckeditor.com/#!/guide/plugin_sdk_integration_with_acf
			allowedContent:
			'div(!ui-accordion,!template-custom-accordion);' +
			'h3(!ui-accordion-header,!foobar123,!foobar);' +
			'div(!ui-accordion-content);',

			// Minimum HTML which is required by this widget to work.
			requiredContent: 'div(static-simple-2columns)',

			// Define two nested editable areas.
			editables: editables,

			// Define the template of a new widget.
			// @todo: template-custom-accordion__toolbar could probably defined in upcast and removed in downcast.
			template:
			'<div class="ui-accordion template-custom-accordion">' +
			'  <div class="template-custom-accordion__toolbar">' +
			'    <a class="template-custom-accordion__toolbar-btn-add" href="#">Add</a>' +
			'    <a class="template-custom-accordion__toolbar-btn-remove" href="#">Remove</a>' +
			'  </div>' +
			'  <h3 class="ui-accordion-header ui-accordion-header-1">Accordion title</h3>' +
			'  <div class="ui-accordion-content ui-accordion-content-1">' +
			'  	<p>Accordion content</p>' +
			'  </div>' +
			'  <h3 class="ui-accordion-header ui-accordion-header-2">Accordion title</h3>' +
			'  <div class="ui-accordion-content ui-accordion-content-2">' +
			'  	<p>Accordion content</p>' +
			'  </div>' +
			'</div>',

			// Check the elements that need to be converted to widgets.
			//
			// Note: The "element" argument is an instance of http://docs.ckeditor.com/#!/api/CKEDITOR.htmlParser.element
			// so it is not a real DOM element yet. This is caused by the fact that upcasting is performed
			// during data processing which is done on DOM represented by JavaScript objects.
			upcast: function( element ) {
				// Return "true" (that element needs to converted to a Simple Box widget)
				// for all <div> elements with a "simplebox" class.
				return element.name == 'div' && element.hasClass('template-custom-accordion');
			},

			init: function() {
				var $widget = jQuery(this.element.$);
				var currentAccordionItemCount = 0;

				// Find the current index.
				$widget.find('.template-custom-accordion__toolbar-btn-add').click(function() {
					$widget.find('.ui-accordion-header').each(function() {
						var matches = this.className.match(/ui-accordion-header-([0-9])/);
						currentAccordionItemCount = matches[1];
					});

					// Increase the index.
					currentAccordionItemCount++;

					var templateHeader = '<h3 class="ui-accordion-header ui-accordion-header-' + currentAccordionItemCount + '">Accordion title</h3>',
						templateContent = '<div class="ui-accordion-content ui-accordion-content-' + currentAccordionItemCount + '">' +
							'<p>Accordion content</p>' +
							'</div>';

					// Create dom elements.
					var elementHeader = CKEDITOR.dom.element.createFromHtml(templateHeader);
					var elementContent = CKEDITOR.dom.element.createFromHtml(templateContent);

					// Append new HTML.
					$widget.append(jQuery(elementHeader.$));
					$widget.append(jQuery(elementContent.$));
				});
			}
		});

		// Add the button for the widget to properly trigger all rules for ACF and
		// later hide the button with css.
		editor.ui.addButton && editor.ui.addButton('vp_accordion_button', {
			label: 'Dummy label',
			command: 'vp_accordion'
		});
	}
});
