/**
 * @license Copyright (c) 2003-2015, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or http://ckeditor.com/license
 */

CKEDITOR.editorConfig = function( config ) {
	// Define changes to default configuration here. For example:
	// config.language = 'fr';
	// config.uiColor = '#AADC6E';

    config.toolbarGroups = [
        { name: 'document', groups: [ 'mode', 'document', 'doctools' ] },
        { name: 'clipboard', groups: [ 'clipboard', 'undo' ] },
        { name: 'editing', groups: [ 'find', 'selection', 'spellchecker', 'editing' ] },
        { name: 'forms', groups: [ 'forms' ] },
        { name: 'basicstyles', groups: [ 'basicstyles', 'cleanup' ] },
        { name: 'paragraph', groups: [ 'list', 'indent', 'align', 'blocks', 'bidi', 'paragraph' ] },
        { name: 'links', groups: [ 'links' ] },
        { name: 'insert', groups: [ 'insert' ] },
        { name: 'styles', groups: [ 'styles' ] },
        { name: 'colors', groups: [ 'colors' ] },
        { name: 'tools', groups: [ 'tools' ] },
        { name: 'others', groups: [ 'others' ] },
        { name: 'about', groups: [ 'about' ] }
    ];

    // StylesSet config of Abayo1.0
    // config.stylesSet = [
    // { name: 'Strong Emphasis', element: 'strong' },
    // { name: 'Emphasis', element: 'em' },
    // { name: 'Heading 1', element: 'h1' },
    // { name: 'Heading 2', element: 'h2' },
    // { name: 'Heading 3', element: 'h3' },
    // { name: 'Heading 4', element: 'h4' },
    // { name: 'Heading 5', element: 'h5' },
    // { name: 'Heading 6', element: 'h6' },
    // { name: 'lead', element: 'p', attributes: { 'class': 'lead' }},
    // ];


    config.removeButtons = 'Source,Save,Templates,NewPage,Preview,Print,Replace,Find,SelectAll,Scayt,Form,Checkbox,Radio,TextField,Textarea,Select,Button,ImageButton,HiddenField,CreateDiv,BidiLtr,BidiRtl,Language,Flash,Table,Smiley,PageBreak,Iframe,Maximize,ShowBlocks,About';


    config.extraPlugins = 'sharedspace,butane,placebo,lineheight,iconfont'; 
    config.removePlugins = 'maximize,resize,floatingspace,magicline';

    // config.extraPlugins = 'lineutils,widget,butane,placebo,lineheight,fontawesome';
    // config.removePlugins = 'magicline,ckeditor-gwf-plugin,gwfplugin';

    config.fontSize_sizes = '8/8px;9/9px;10/10px;11/11px;12/12px;13/13px;14/14px;15/15px;16/16px;18/18px;20/20px;21/21px;22/22px;24/24px;26/26px;28/28px;36/36px;48/48px;72/72px;';
    config.line_height = '1;1.1;1.2;1.3;1.4;1.5;1.6;1.7;1.8;1.9;2;3';
    config.font_names = 'Open Sans (Default)/\'Open Sans\', sans-serif;' + config.font_names;

    //Remove all CSS by entering as plain text
    config.enterMode = CKEDITOR.ENTER_BR;
    config.shiftEnterMode = CKEDITOR.ENTER_BR;
    config.forcePasteAsPlainText = false;
    

    // config.protectedSource.push(/<(i|h1|h2|h3|h4|h5|h6)[^>]*><\/(i|h1|h2|h3|h4|h5|h6)>/g); 
    
    config.allowedContent = true;
    // config.extraAllowedContent = 'p(*)[*]{*};div(*)[*]{*};li(*)[*]{*};ul(*)[*]{*};h1(*)[*]{*};h2(*)[*]{*};h3(*)[*]{*};h4(*)[*]{*};h5(*)[*]{*};h6(*)[*]{*}';

    // CKEDITOR.dtd.$removeEmpty['i']  = false;
    // CKEDITOR.dtd.$removeEmpty['h1'] = false;
    // CKEDITOR.dtd.$removeEmpty['h2'] = false;
    // CKEDITOR.dtd.$removeEmpty['h3'] = false;
    // CKEDITOR.dtd.$removeEmpty['h4'] = false;
    // CKEDITOR.dtd.$removeEmpty['h5'] = false;
    // CKEDITOR.dtd.$removeEmpty['span'] = false;
};
