'use strict';

angular.module('icullenAngularAdminApp')
  .service('CkeditorConfigService', function (ckeditorSkinPath) {
   

   CKEDITOR.on('dialogDefinition', function (ev) {
      var dialogName = ev.data.name;
      var dialogDefinition = ev.data.definition;

      if (dialogName === 'table') {
        var addCssClass = dialogDefinition.getContents('advanced').get('advCSSClasses');
       addCssClass['default'] = 'generic';
       var infoTab = dialogDefinition.getContents('info');
        infoTab.get('selHeaders')['default'] = 'row';
        infoTab.get( 'txtWidth' )['default']='100%';
        infoTab.remove('txtBorder');
        infoTab.remove('cmbAlign');
        infoTab.remove('txtCellSpace');
        infoTab.remove('txtCellPad');
        infoTab.remove('txtCaption');
        infoTab.remove('txtSummary');
      }

      // if (dialogName === 'link') {
       
      //  var oldImplementation = dialogDefinition.onOk;
      //   dialogDefinition.onOk = function( e ) {
      //       var editor = this.getParentEditor();
      //       console.log(editor);
      //       console.log("inside link dialgog onOk");
      //       console.log( e );
      //       oldImplementation.apply( this, [].slice.call( arguments ) );
      //   };
       
      // }
    });

   CKEDITOR.stylesSet.add('cullenStyles', [
       //{ name: 'My Custom Block', element: 'h3', styles: { 'color': 'blue'} },
       // Block-level styles
        { name: 'Caption', element: ['p'], attributes: {'class': 'caption'} },
        { name: 'Citation', element: ['p'], attributes: {'class': 'citation'} },
        { name: 'Indent', element: ['p'], attributes: {'class': 'indent'} },
        { name: 'Generic Table', element: ['table'], attributes: {'class': 'generic'} },
        { name: 'PDF Image Small', type: 'widget', widget: 'image', attributes: {'class': 'pdf-image-s'} },
        { name: 'PDF Image Medium', type: 'widget', widget: 'image', attributes: {'class': 'pdf-image-m'} },
        { name: 'PDF Image Large', type: 'widget', widget: 'image', attributes: {'class': 'pdf-image-l'} },
        { name: 'PDF Image XLarge', type: 'widget', widget: 'image', attributes: {'class': 'pdf-image-xl'} },
        { name: 'Remove Styles', element: ['p','img','span','div','ul','li'], attributes: {'class': ''} },
        // Inline styles
        { name: 'Currency', element: 'span', attributes: {'class': 'currency'} },
        //{ name: 'Generic Table', element: ['table'], attributes: {'class': 'generic'} },
      ]);


    this.configTable = function (enableTrackChanges,allowComments){


        var trackChangesButtons= { name: 'lite', items: [ 'lite-toggletracking', 'lite-toggleshow', 'lite-acceptall', 'lite-rejectall', 'lite-acceptone', 'lite-rejectone' ] };
        var commentsButtons = { name: 'comments', items: ['annotate'] };
        
           var config = {
             
              extraPlugins:'nbsp,cullenimage,lance,quicktable,notification,tableresize,find,image2,widget,lineutils,widgetselection',
              toolbar : [
                { name: 'clipboard', items: [ 'Cut', 'Copy', 'Paste', 'PasteText', '-', 'Undo', 'Redo' ] },
                { name: 'editing', items: [ 'Scayt','Find'] },
                { name: 'links', items: [ 'Link', 'Unlink'] },
                { name: 'insert', items: [ 'Table', 'HorizontalRule' ] },
                { name: 'tools', items: [ 'Resize','Maximize'] },
                { name: 'basicstyles', items: [ 'Bold', 'Italic','RemoveFormat' ] },
                '/',
                { name: 'paragraph', items: ['BulletedList'] },
                { name: 'styles', items: [ 'Styles', 'Format' ] },
                { name: 'extra', items: ['cullenimage'] },
                { name: 'document', items: [ 'Source' ] }
              ],
              disallowedContent: 'style;[style];[class](Mso*)',
              extraAllowedContent: 'img div a[*](*);*[id];br;h1;h5;h6;span(!currency)',
              fillEmptyBlocks:false,
              autoParagraph : false,
              scayt_sLang: 'en_GB',
              wsc_lang : "en_GB",
              scayt_autoStartup: true,
              format_tags : 'p;h4',
              stylesSet:'cullenStyles',
              title:false,
              startupShowBorders:false,
              qtClass: 'generic', // Class of table
              height:'100px',
              removePlugins:'magicline',
              bodyClass:'authoring article_content',
              contentsCss: ['styles/ckeditor_authoring.css'] // ['css/style.css', 'css/global.css', 'css/authoring.css', 'css/authoring_base.css']
          };

        if(enableTrackChanges){
           config.toolbar.push(trackChangesButtons);
           config.extraPlugins=config.extraPlugins+',lite';
        }

        if(allowComments){
          config.toolbar.push(commentsButtons);
        }

        config.skin = 'flat,' + ckeditorSkinPath;

        return config;
    };
  
    this.configSection = function (enableTrackChanges, enableViewSelection,allowComments){

        var trackChangesPlugin= { name: 'lite', items: [ 'lite-toggletracking', 'lite-toggleshow', 'lite-acceptall', 'lite-rejectall', 'lite-acceptone', 'lite-rejectone' ] };
        var extraPluginButtons = { name: 'extra', items: ['insertview','cullenimage','Sourcedialog'] };
        var commentsButtons = { name: 'comments', items: ['annotate'] };
        

        var config = {
               
                extraPlugins:'nbsp,cullenimage,insertview,sourcedialog,lance,quicktable,notification,find,tableresize,image2,widget,lineutils,widgetselection',
                toolbar : [
                  { name: 'clipboard', items: [ 'Cut', 'Copy', 'Paste', 'PasteText', '-', 'Undo', 'Redo' ] },
                  { name: 'editing', items: [ 'Scayt','Find'] },
                  { name: 'links', items: [ 'Link', 'Unlink'] },
                  { name: 'insert', items: [ 'Table', 'HorizontalRule' ] },
                  { name: 'tools', items: [ 'Resize' ] },
                  { name: 'basicstyles', items: [ 'Bold', 'Italic','RemoveFormat' ] },
                  '/',
                  { name: 'paragraph', items: ['BulletedList'] },
                  { name: 'styles', items: [ 'Styles', 'Format' ] }
                ],
                // allowedContent:true,
                disallowedContent: 'style;[style];[class](Mso*)',
                extraAllowedContent: 'img div a[*](*);*[id];br;h1;h5;h6;span(!currency)',
                fillEmptyBlocks:false,
                autoParagraph : false,
                scayt_sLang: 'en_GB',
                wsc_lang : "en_GB",
                scayt_autoStartup: true,
                format_tags : 'p;h2;h3;h4',
                stylesSet:'cullenStyles',
                title:false,
                startupShowBorders:false,
                qtClass: 'generic', // Class of table
                removePlugins:'magicline',
                // qtRows: 20, // Count of rows
                // qtColumns: 20, // Count of columns
                // qtBorder: '1', // Border of inserted table
                // qtWidth: '90%', // Width of inserted table
                // qtStyle: { 'border-collapse' : 'collapse' },
              
                // qtCellPadding: '0', // Cell padding table
                // qtCellSpacing: '0', // Cell spacing table
                // //qtPreviewBorder: '4px double black', // preview table border 
                // qtPreviewSize: '4px', // Preview table cell size 
                // qtPreviewBackground: '#c8def4' // preview table background (hover)
                
            };



        if(enableTrackChanges){
           config.toolbar.push(trackChangesPlugin);
           config.extraPlugins=config.extraPlugins+',lite';
        }

        if(enableViewSelection){
            config.toolbar.push(extraPluginButtons);
        }

        if(allowComments){
          config.toolbar.push(commentsButtons);
        }

          return config;
        };

  });