/**
 * FCKeditor - The text editor for Internet - http://www.fckeditor.net
 * Copyright (C) 2003-2007 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 */

/**
 * This plugin allows for easy linking to local drive documents (such
 * as resources found on shared group drives).  It escapes URI links, eg:
 * replaces spaces with %20 and adds the appropriate markup.
 *
 *
 * Installation:
 * 1. Unzip the file into: 
 *	/wiki/extensions/FCKeditor/plugins/
 *
 * 2. Edit /wiki/extensions/FCKeditor/fckeditor_config.js
 *
 * Add to the top of the page:
 *	FCKConfig.Plugins.Add("locallink", "en");
 *
 * Add to your desired placement for the button
 *	'Local_Link'
 * eg:
 *	['Link','Unlink','Anchor','Local_Link'],
 *
 * 3. Make sure you allow file:// links by editing /wiki/LocalSettings.php 
 * with the following:
 * 	$wgUrlProtocols[] = "file:";
 *
 *
 * Known issues:
 * Linux/Unix browers (eg Firefox, Opera)
 * The value of the file input box is only the filename and does not include
 * the full path.  I'm not sure why this is, or how to overcome it.  Eg:
 * /loc/of/the/file.ext is only reported as file.ext
 *
 *
 * FCKeditor Plugin reference:
 * http://docs.fckeditor.net/FCKeditor_2.x/Developers_Guide/Customization/Plug-ins
 *
 *
 * Change history:
 *      080610  Michael Tran (dublue@gmail.com)
 *              creation
 */

// register the local link command
FCKCommands.RegisterCommand(
	"Local_Link", 
	new FCKDialogCommand(
		FCKLang["DlgLocalLinkTitle"],
		FCKLang["DlgLocalLinkTitle"],
		FCKConfig.PluginsPath + "locallink/dialogs/locallink.html",
		500,
	 	300
	)
);

// create the local link toolbar button
var objLocalLink = new FCKToolbarButton("Local_Link", FCKLang["DlgLocalLinkTitle"], null, FCK_TOOLBARITEM_ICONTEXT);
objLocalLink.IconPath = FCKConfig.PluginsPath + "locallink/images/locallink.gif";
FCKToolbarItems.RegisterItem("Local_Link", objLocalLink);

