function writeBody() {
	var d = window.document;
	var is_html = false;

	d.open();

	// iterate through each text input.
	for( var txtid = 0; txtid < this.textInputs.length; txtid++ ) {
		var end_idx = 0;
		var begin_idx = 0;
		var tagStart = 0;
		var tagEnd = 0;
		var abort = false;
		var srch;
		d.writeln( '<form name="textInput'+txtid+'">' );
		var wordtxt = this.textInputs[txtid];
		this.indexes[txtid] = [];

		if( wordtxt ) {
			var orig = this.originalSpellings[txtid];
			if( !orig ) break;

			//!!! plain text, or HTML mode?
			d.writeln( '<div class="plainText">' );
			var keepLooking;

			// iterate through each occurrence of a misspelled word.
			for( var i = 0; i < orig.length; i++ ) {
				// find the position of the current misspelled word,
				// starting at the last misspelled word.
				// and keep looking if it's a substring of another word
				do {
					begin_idx = wordtxt.indexOf( orig[i], end_idx );

					// word not found? messed up!
					//if( begin_idx == -1 ) { break; // lets 'usually' not mess up if this happens - MWB
					// One missing could possibly make us omit lots of others with this,
					// but with this being the only 'unusual' way of messing up.
					abort = false;
					while ( begin_idx == -1 && !abort) {
						this.originalSpellings[txtid].splice(i,1); // get rid of the word
						this.suggestions[txtid].splice(i,1); // get rid of its suggestions
						if(i<orig.length) begin_idx = wordtxt.indexOf( orig[i], end_idx );
						else abort=true;
					}

					if(abort) break;

 					end_idx = begin_idx + orig[i].length;

 					// check to see if word is beyond start of next html tag - MWB
					if(tagStart<begin_idx) { // prevent getting a FUBAR doc - MWB
						keepLooking=true;
						end_idx=tagEnd+1; // search again after next tag
						tagStart=wordtxt.indexOf("<",tagEnd+1);// move to next tag
						if(tagStart == -1) tagStart=tagEnd=wordtxt.length; // no more tags
						else tagEnd=wordtxt.indexOf(">",tagStart+1);
					}
					else if(this._isWordChar(wordtxt.charAt(begin_idx-1))) keepLooking=true;
					else if(this._isWordChar(wordtxt.charAt(end_idx))) keepLooking=true;
					else keepLooking=false;
				} while ( keepLooking );

				if(!abort) { // we have no word if abort==true
					// keep track of its position in the original text.
					this.indexes[txtid][i] = begin_idx;

					// write out the characters before the current misspelled word
					for( var j = this._lastPos( txtid, i ); j < begin_idx; j++ ) {
						// !!! html mode? make it html compatible
						d.write( this.printForHtml( wordtxt.charAt( j )));
					}

					// write out the misspelled word.
					d.write( this._wordInputStr( orig[i] , txtid, i));
				}
				// if this is the last word, write out the rest of the text
 				// if( i == orig.length-1 ) {
				if( i >= orig.length-1 ) { // == orig.length if last word(s) not found
				  d.write( printForHtml( wordtxt.substr( end_idx )));
				}
			}
			d.writeln( '</div>' );
		}
		d.writeln( '</form>' );
	}
	//for ( var j = 0; j < d.forms.length; j++ ) {
	//	alert( d.forms[j].name );
	//	for( var k = 0; k < d.forms[j].elements.length; k++ ) {
	//		alert( d.forms[j].elements[k].name + ": " + d.forms[j].elements[k].value );
	//	}
	//}

	// set the _forms property
	this._forms = d.forms;

	d.close();

	/* Replace all hyperlinks with spans without the href's that look like links.
	 * This prevents being able to break it by navigating the wordWindow with links.
	 */
	var find = /<a(\s[^\>]*)href=\"[^\"]*\"(.*?)\<\/a\>/gi;
	var repl = '<span style="color:blue;text-decoration:underline"$1$2</span>';
	//d.body.innerHTML = d.body.innerHTML.replace(find,repl); //memory leak for IE?
	var doc = d.body.innerHTML.replace(find,repl);
	d.body.innerHTML = doc;
}