<!--
 * FCKeditor - The text editor for internet
 * Copyright (C) 2003-2005 Frederico Caldeira Knabben
 * 
 * Licensed under the terms of the GNU Lesser General Public License:
 * 		http://www.opensource.org/licenses/lgpl-license.php
 * 
 * For further information visit:
 * 		http://www.fckeditor.net/
 * 
 * "Support Open Source software. What about a donation today?"
 * 
 * File Name: fckeditor.asp
 * 	This is the integration file for ASP.
 * 
 * 	It defines the FCKeditor class that can be used to create editor
 * 	instances in ASP pages on server side.
 * 
 * File Authors:
 * 		Frederico Caldeira Knabben (fredck@fckeditor.net)
-->
<%
function FCKeditor(instanceName, width, height, toolbarSet, value)
{
	//	ASP Constructor (by Trent Jones<trenton.jones@gmail.com>)
	//	Author:	Trent Jones
	//	Date:	17 May 2006
	//	Version:	1.0.0

	var SELF = "FCKeditor";
	var VERSION = "1.0.0";

	this.BasePath			= "/fckeditor/";
	this.InstanceName		= instanceName || "";
	this.Width			= width || "100%";
	this.Height			= height || "200";
	this.ToolbarSet		= toolbarSet || "Default";
	this.Value			= value || "";

	this.Config			= new Object();//Server.CreateObject("Scripting.Dictionary");
}

FCKeditor.prototype.CreateFCKeditor = function(instanceName, width, height)
{
	this.Width			= width;
	this.Height			= height;
	return this.Create(instanceName);
}

FCKeditor.prototype.Create		= function(instanceName)
{
	var text = "";
	text +=  "<div>";

	if (this.IsCompatible())
	{
		var sFile;
		if (Request.QueryString( "fcksource" ) == "true")
			sFile = "fckeditor.original.html"
		else
			sFile = "fckeditor.html"
		
		var sLink
		sLink = this.BasePath + "/editor/" + sFile + "?InstanceName=" + instanceName;

		if (this.ToolbarSet != "")
			sLink = sLink + "&amp;Toolbar=" + this.ToolbarSet;
		
		// Render the linked hidden field.
		text +=  "<input type=\"hidden\" id=\"" + instanceName + "\" name=\"" + instanceName + "\" value=\"" + Server.HTMLEncode( this.Value ) + "\" style=\"display:none\" />";

		// Render the configurations hidden field.
		text +=  "<input type=\"hidden\" id=\"" + instanceName + "___Config\" value=\"" + this.GetConfigFieldString() + "\" style=\"display:none\" />";

		// Render the editor IFRAME.
		text +=  "<iframe id=\"" + instanceName + "___Frame\" src=\"" + sLink + "\" width=\"" + this.Width + "\" height=\"" + this.Height + "\" frameborder=\"no\" scrolling=\"no\"></iframe>";
	}
	else
	{
		var sWidthCSS, sHeightCSS;

		if (this.Width.indexOf("%") > 0)
			sWidthCSS = this.Width;
		else
			sWidthCSS = this.Width + "px"
		
		if ( this.Height.indexOf("%") > 0 )
			sHeightCSS = this.Height
		else
			sHeightCSS = this.Height + "px"
		
		text +=  "<textarea name=\"" + instanceName + "\" rows=\"4\" cols=\"40\" style=\"width: " + sWidthCSS + "; height: " + sHeightCSS + "\">" + Server.HTMLEncode( this.Value ) + "</textarea>";
	}

	text +=  "</div>";
	return text;
}
	
FCKeditor.prototype.IsCompatible		= function()
{
	var sAgent
	sAgent = "" + Request.ServerVariables("HTTP_USER_AGENT");
	var iVersion;
	var isCompatible;

	if (sAgent.indexOf("MSIE") > -1 && sAgent.indexOf("mac") <= 0  && sAgent.indexOf("Opera") <= 0 )
	{
		iVersion = 1*( this.ToNumericFormat( sAgent.substring((sAgent.indexOf("MSIE") + 5), (sAgent.indexOf("MSIE") + 8)) ) );
		isCompatible = ( iVersion >= 5.5 )
	}
	else if (sAgent.indexOf("Gecko/") > 0)
	{
		iVersion = 1*( sAgent.substring((sAgent.indexOf("Gecko/") + 6), (sAgent.indexOf("Gecko/") + 14)) )
		isCompatible = ( iVersion >= 20030210 )
	}
	else
	{
		IsCompatible = false;
	}
	return isCompatible;
}

// By Agrotic
// On ASP, when converting string to numbers, the number decimal separator is localized
// so 5.5 will not work on systems were the separator is "," and vice versa.
FCKeditor.prototype.ToNumericFormat	= function( numberStr )
{
	if (!isNaN("5.5"))
		numberStr = numberStr.replace(",", ".");
	else
		numberStr = numberStr.replace(".", ",");
	return numberStr;
}

FCKeditor.prototype.GetConfigFieldString	= function()
{
	var sParams = "";

	var bFirst;
	bFirst = true;

	var sKey;
	for (sKey in this.Config)
	{	
		if (bFirst == false)
			sParams += "&amp;"
		else
			bFirst = false;
		sParams += this.EncodeConfig( sKey ) + "=" + this.EncodeConfig( this.Config[sKey] );
	}
	return sParams;
}	

FCKeditor.prototype.EncodeConfig		= function(valueToEncode)
{
		valueToEncode += "";
		valueToEncode = valueToEncode.replace("&", "%26" );
		valueToEncode = valueToEncode.replace("=", "%3D" )
		valueToEncode = valueToEncode.replace("\"\"", "%22" )
		return valueToEncode;
}
%>