﻿using System;
using System.Collections.Generic;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

namespace FredCK.FCKeditorV2.Ajax
{
    /// <summary>
    /// Extend FCK to provide script control implementation
    /// </summary>
    [ToolboxData("<{0}:FCKeditorAjax runat=server></{0}:FCKeditorAjax>")]
    public class FCKeditorAjax : FCKeditor, IScriptControl
    {
        /// <summary>
        /// Empty constructor
        /// </summary>
        public FCKeditorAjax() : base()
        {
        }

        /// <summary>
        /// Override OnLoad to register a dummy OnSubmit statement, which allows us access to that event in the
        /// attached Javascript behaviour
        /// </summary>
        /// <param name="e"></param>
        protected override void OnLoad(EventArgs e)
        {
            base.OnLoad(e);
            // If AJAX is supported, wire up our own submit method and prevent FCK's!
            if (ScriptManager.GetCurrent(Page).SupportsPartialRendering)
            {
                // Register the dummy function
                ScriptManager.RegisterOnSubmitStatement(this, typeof(FCKeditorAjax), "FCKeditorAjaxOnSubmit", "FredCK.FCKeditorV2.Ajax.FCKeditorAjax.WebForm_OnSubmit();");

                // Set our config value to disable the editor's usual handling of events,
                // since we are manually hooking into AJAX's submit
                Config["PreventSubmitHandler"] = "true";
            }
        }

        #region IScriptControl Implementation

        // See:
        // http://www.asp.net/AJAX/Documentation/Live/tutorials/IScriptControlTutorial1.aspx
     
        private ScriptManager sm = null;
     
        public IEnumerable<ScriptDescriptor> GetScriptDescriptors()
        {
            ScriptControlDescriptor descriptor = new ScriptControlDescriptor("FredCK.FCKeditorV2.Ajax.FCKeditorAjax", ClientID);
            yield return descriptor;
        }

        IEnumerable<ScriptReference> IScriptControl.GetScriptReferences()
        {
            ScriptReference reference = new ScriptReference("FredCK.FCKeditorV2.Ajax.FCKeditorAjax.js", "FredCK.FCKeditorV2.Ajax");
            yield return reference;
        }

        protected override void OnPreRender(EventArgs e)
        {
            if (!this.DesignMode)
            {
                // Test for ScriptManager and register ourself if it exists
                sm = ScriptManager.GetCurrent(Page);

                if (sm != null)
                {
                    sm.RegisterScriptControl(this);
                }
            }

            base.OnPreRender(e);
        }

        protected override void Render(HtmlTextWriter writer)
        {
            // Register only when rendering, to ensure scripts aren't registered if the
            // editor is hidden.
            if (sm != null)
                sm.RegisterScriptDescriptors(this);

            base.Render(writer);
        }

        #endregion
    }
}