﻿/// <reference name="MicrosoftAjax.js"/>

Type.registerNamespace("FredCK.FCKeditorV2.Ajax");

FredCK.FCKeditorV2.Ajax.FCKeditorAjax = function(element) {
    FredCK.FCKeditorV2.Ajax.FCKeditorAjax.initializeBase(this, [element]);
}

FredCK.FCKeditorV2.Ajax.FCKeditorAjax.prototype = {

    /// <summary>Handler for pre-submit, triggers the FCK to update the hidden field; called from our WebForm_OnSubmit (below)</summary>
    _onSubmit: function() {
        try { 
            if(typeof(FCKeditorAPI) == 'object') {
                var element = this.get_element();
                var instance = FCKeditorAPI.GetInstance(element.id);
                if (instance!=undefined) {
                    var result = instance.UpdateLinkedField(); 
                }
            }
        } catch(err) { }
        
    },
    
    initialize: function() {
        FredCK.FCKeditorV2.Ajax.FCKeditorAjax.callBaseMethod(this, 'initialize');
    },
    
    dispose: function() {

        // Manually call the FCK's BeforeUnload routine, so that cleanup will be correctly triggered.
        // Usually initiated by window.beforeunload, however that doesn't get called in partial postback
        // scenarios.
        if(typeof(FCKeditorAPI) == 'object') {
            var element = this.get_element();
            var instance = FCKeditorAPI.GetInstance(element.id);
            if (instance.Cleanup)
                instance.Cleanup();
        }

        FredCK.FCKeditorV2.Ajax.FCKeditorAjax.callBaseMethod(this, 'dispose');
    }
}

FredCK.FCKeditorV2.Ajax.FCKeditorAjax.registerClass('FredCK.FCKeditorV2.Ajax.FCKeditorAjax', Sys.UI.Control);

FredCK.FCKeditorV2.Ajax.FCKeditorAjax.WebForm_OnSubmit = function() {
    /// <summary>
    /// Registered in the controls OnLoad override, to be executed only if the FCK is being submitted inside
    /// an UpdatePanel
    /// </summary>
    /// <returns type="Boolean">
    /// Always true, since we are not performing any validation here (leave this to ordinary validators,
    /// although perhaps we need to test whether this event happens *before* or *after* validation...)
    /// </returns>
    
    // Loop through all components and call the onSubmit of any FCK components that are registered
    var components = Sys.Application.getComponents();
    for(var i = 0 ; i < components.length ; i++) {
        var component = components[i];
        if (FredCK.FCKeditorV2.Ajax.FCKeditorAjax.isInstanceOfType(component)) {
            component._onSubmit();
        }
    }
    return true;
}
