/*
 * Decompiled with CFR 0.152.
 */
package net.fckeditor.connector;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.fckeditor.handlers.CommandHandler;
import net.fckeditor.handlers.ConnectorHandler;
import net.fckeditor.handlers.ExtensionsHandler;
import net.fckeditor.handlers.LocaleResolverHandler;
import net.fckeditor.handlers.RequestCycleHandler;
import net.fckeditor.handlers.ResourceTypeHandler;
import net.fckeditor.response.UploadResponse;
import net.fckeditor.response.XmlResponse;
import net.fckeditor.tool.Utils;
import net.fckeditor.tool.UtilsFile;
import net.fckeditor.tool.UtilsResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectorServlet
extends HttpServlet {
    private static final long serialVersionUID = -5742008970929377161L;
    private static final Logger logger = LoggerFactory.getLogger(ConnectorServlet.class);

    public void init() throws ServletException, IllegalArgumentException {
        String realDefaultUserFilesPath = this.getServletContext().getRealPath(ConnectorHandler.getDefaultUserFilesPath());
        File defaultUserFilesDir = new File(realDefaultUserFilesPath);
        UtilsFile.checkDirAndCreate(defaultUserFilesDir);
        logger.info("ConnectorServlet successfully initialized!");
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        XmlResponse xr;
        logger.debug("Entering ConnectorServlet#doGet");
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/xml; charset=UTF-8");
        response.setHeader("Cache-Control", "no-cache");
        PrintWriter out = response.getWriter();
        String commandStr = request.getParameter("Command");
        String typeStr = request.getParameter("Type");
        String currentFolderStr = request.getParameter("CurrentFolder");
        logger.debug("Parameter Command: {}", (Object)commandStr);
        logger.debug("Parameter Type: {}", (Object)typeStr);
        logger.debug("Parameter CurrentFolder: {}", (Object)currentFolderStr);
        LocaleResolverHandler lrh = new LocaleResolverHandler(request);
        if (!RequestCycleHandler.isEnabledForFileBrowsing(request)) {
            xr = new XmlResponse(1, lrh.getString("message.connector.fileBrowsing.disabled"));
        } else if (!CommandHandler.isValidForGet(commandStr)) {
            xr = new XmlResponse(1, lrh.getString("message.connector.invalid_command_specified"));
        } else if (typeStr != null && !ResourceTypeHandler.isValid(typeStr)) {
            xr = new XmlResponse(1, lrh.getString("message.connector.invalid_type_specified"));
        } else if (!UtilsFile.isValidPath(currentFolderStr)) {
            xr = new XmlResponse(1, lrh.getString("message.connector.invalid_current_folder_speficied"));
        } else {
            CommandHandler command = CommandHandler.getCommand(commandStr);
            ResourceTypeHandler resourceType = ResourceTypeHandler.getDefaultResourceType(typeStr);
            String typePath = UtilsFile.constructServerSidePath(request, resourceType);
            String typeDirPath = this.getServletContext().getRealPath(typePath);
            File typeDir = new File(typeDirPath);
            UtilsFile.checkDirAndCreate(typeDir);
            File currentDir = new File(typeDir, currentFolderStr);
            if (!currentDir.exists()) {
                xr = new XmlResponse(102);
            } else {
                xr = new XmlResponse(command, resourceType, currentFolderStr, UtilsResponse.constructResponseUrl(request, resourceType, currentFolderStr, true, ConnectorHandler.isFullUrl()));
                if (command.equals(CommandHandler.GET_FOLDERS)) {
                    xr.setFolders(currentDir);
                } else if (command.equals(CommandHandler.GET_FOLDERS_AND_FILES)) {
                    xr.setFoldersAndFiles(currentDir);
                } else if (command.equals(CommandHandler.CREATE_FOLDER)) {
                    String newFolderStr = UtilsFile.sanitizeFolderName(request.getParameter("NewFolderName"));
                    logger.debug("Parameter NewFolderName: {}", (Object)newFolderStr);
                    File newFolder = new File(currentDir, newFolderStr);
                    int errorNumber = 110;
                    if (newFolder.exists()) {
                        errorNumber = 101;
                    } else {
                        try {
                            errorNumber = newFolder.mkdir() ? 0 : 102;
                        }
                        catch (SecurityException e) {
                            errorNumber = 103;
                        }
                    }
                    xr.setError(errorNumber);
                }
            }
        }
        out.print(xr);
        out.flush();
        out.close();
        logger.debug("Exiting ConnectorServlet#doGet");
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        UploadResponse ur;
        logger.debug("Entering Connector#doPost");
        response.setCharacterEncoding("UTF-8");
        response.setContentType("text/html; charset=UTF-8");
        response.setHeader("Cache-Control", "no-cache");
        PrintWriter out = response.getWriter();
        String commandStr = request.getParameter("Command");
        String typeStr = request.getParameter("Type");
        String currentFolderStr = request.getParameter("CurrentFolder");
        logger.debug("Parameter Command: {}", (Object)commandStr);
        logger.debug("Parameter Type: {}", (Object)typeStr);
        logger.debug("Parameter CurrentFolder: {}", (Object)currentFolderStr);
        LocaleResolverHandler lrh = new LocaleResolverHandler(request);
        if (Utils.isEmpty(commandStr) && Utils.isEmpty(currentFolderStr)) {
            commandStr = "QuickUpload";
            currentFolderStr = "/";
        }
        if (!RequestCycleHandler.isEnabledForFileUpload(request)) {
            ur = new UploadResponse(203, null, null, lrh.getString("message.connector.fileUpload.disabled"));
        } else if (!CommandHandler.isValidForPost(commandStr)) {
            ur = new UploadResponse(1, null, null, lrh.getString("message.connector.invalid_command_specified"));
        } else if (typeStr != null && !ResourceTypeHandler.isValid(typeStr)) {
            ur = new UploadResponse(1, null, null, lrh.getString("message.connector.invalid_type_specified"));
        } else if (!UtilsFile.isValidPath(currentFolderStr)) {
            ur = new UploadResponse(1, null, null, lrh.getString("message.connector.invalid_current_folder_speficied"));
        } else {
            ResourceTypeHandler resourceType = ResourceTypeHandler.getDefaultResourceType(typeStr);
            String typePath = UtilsFile.constructServerSidePath(request, resourceType);
            String typeDirPath = this.getServletContext().getRealPath(typePath);
            File typeDir = new File(typeDirPath);
            UtilsFile.checkDirAndCreate(typeDir);
            File currentDir = new File(typeDir, currentFolderStr);
            if (!currentDir.exists()) {
                ur = new UploadResponse(1, null, null, lrh.getString("message.connector.invalid_current_folder_speficied"));
            } else {
                String newFilename = null;
                DiskFileItemFactory factory = new DiskFileItemFactory();
                ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
                try {
                    List items = upload.parseRequest(request);
                    FileItem uplFile = (FileItem)items.get(0);
                    String rawName = UtilsFile.sanitizeFileName(uplFile.getName());
                    String filename = FilenameUtils.getName((String)rawName);
                    String baseName = FilenameUtils.removeExtension((String)filename);
                    String extension = FilenameUtils.getExtension((String)filename);
                    if (!ExtensionsHandler.isAllowed(resourceType, extension)) {
                        ur = new UploadResponse(202);
                    } else {
                        File pathToSave = new File(currentDir, filename);
                        int counter = 1;
                        while (pathToSave.exists()) {
                            newFilename = baseName.concat("(").concat(String.valueOf(counter)).concat(")").concat(".").concat(extension);
                            pathToSave = new File(currentDir, newFilename);
                            ++counter;
                        }
                        ur = Utils.isEmpty(newFilename) ? new UploadResponse(0, UtilsResponse.constructResponseUrl(request, resourceType, currentFolderStr, true, ConnectorHandler.isFullUrl()).concat(filename)) : new UploadResponse(201, UtilsResponse.constructResponseUrl(request, resourceType, currentFolderStr, true, ConnectorHandler.isFullUrl()).concat(newFilename), newFilename);
                        if (resourceType.equals(ResourceTypeHandler.IMAGE) && ConnectorHandler.isSecureImageUploads()) {
                            if (UtilsFile.isImage(uplFile.getInputStream())) {
                                uplFile.write(pathToSave);
                            } else {
                                uplFile.delete();
                                ur = new UploadResponse(202);
                            }
                        } else {
                            uplFile.write(pathToSave);
                        }
                    }
                }
                catch (Exception e) {
                    ur = new UploadResponse(203);
                }
            }
        }
        out.print(ur);
        out.flush();
        out.close();
        logger.debug("Exiting Connector#doPost");
    }
}

