/*
 * Decompiled with CFR 0.152.
 */
package net.fckeditor.handlers;

import java.util.HashMap;
import java.util.Map;
import net.fckeditor.tool.Utils;

public class CommandHandler {
    private String name;
    private static Map<String, CommandHandler> getCommands = new HashMap<String, CommandHandler>(3);
    private static Map<String, CommandHandler> postCommands = new HashMap<String, CommandHandler>(2);
    public static final CommandHandler GET_FOLDERS = new CommandHandler("GetFolders");
    public static final CommandHandler GET_FOLDERS_AND_FILES = new CommandHandler("GetFoldersAndFiles");
    public static final CommandHandler CREATE_FOLDER = new CommandHandler("CreateFolder");
    public static final CommandHandler FILE_UPLOAD = new CommandHandler("FileUpload");
    public static final CommandHandler QUICK_UPLOAD = new CommandHandler("QuickUpload");

    static {
        getCommands.put(GET_FOLDERS.getName(), GET_FOLDERS);
        getCommands.put(GET_FOLDERS_AND_FILES.getName(), GET_FOLDERS_AND_FILES);
        getCommands.put(CREATE_FOLDER.getName(), CREATE_FOLDER);
        postCommands.put(FILE_UPLOAD.getName(), FILE_UPLOAD);
        postCommands.put(QUICK_UPLOAD.getName(), QUICK_UPLOAD);
    }

    private CommandHandler(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static CommandHandler valueOf(String name) throws IllegalArgumentException {
        if (Utils.isEmpty(name)) {
            throw new IllegalArgumentException();
        }
        if (!CommandHandler.isValidForGet(name) && !CommandHandler.isValidForPost(name)) {
            throw new IllegalArgumentException();
        }
        return getCommands.get(name) != null ? getCommands.get(name) : postCommands.get(name);
    }

    public static boolean isValidForGet(String name) {
        return getCommands.containsKey(name);
    }

    public static boolean isValidForPost(String name) {
        return postCommands.containsKey(name);
    }

    public static CommandHandler getCommand(String name) {
        try {
            return CommandHandler.valueOf(name);
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        try {
            CommandHandler rt = (CommandHandler)obj;
            return this.name.equals(rt.getName());
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }
}

