/*
 * Decompiled with CFR 0.152.
 */
package net.fckeditor.handlers;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.fckeditor.handlers.PropertiesLoader;
import net.fckeditor.handlers.ResourceTypeHandler;
import net.fckeditor.tool.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionsHandler {
    private static Map<ResourceTypeHandler, Set<String>> extensionsAllowed = new HashMap<ResourceTypeHandler, Set<String>>();
    private static Map<ResourceTypeHandler, Set<String>> extensionsDenied = new HashMap<ResourceTypeHandler, Set<String>>();

    static {
        extensionsAllowed.put(ResourceTypeHandler.FILE, Utils.getSet(PropertiesLoader.getProperty("connector.resourceType.file.extensions.allowed")));
        extensionsDenied.put(ResourceTypeHandler.FILE, Utils.getSet(PropertiesLoader.getProperty("connector.resourceType.file.extensions.denied")));
        extensionsAllowed.put(ResourceTypeHandler.MEDIA, Utils.getSet(PropertiesLoader.getProperty("connector.resourceType.media.extensions.allowed")));
        extensionsDenied.put(ResourceTypeHandler.MEDIA, Utils.getSet(PropertiesLoader.getProperty("connector.resourceType.media.extensions.denied")));
        extensionsAllowed.put(ResourceTypeHandler.IMAGE, Utils.getSet(PropertiesLoader.getProperty("connector.resourceType.image.extensions.allowed")));
        extensionsDenied.put(ResourceTypeHandler.IMAGE, Utils.getSet(PropertiesLoader.getProperty("connector.resourceType.image.extensions.denied")));
        extensionsAllowed.put(ResourceTypeHandler.FLASH, Utils.getSet(PropertiesLoader.getProperty("connector.resourceType.flash.extensions.allowed")));
        extensionsDenied.put(ResourceTypeHandler.FLASH, Utils.getSet(PropertiesLoader.getProperty("connector.resourceType.flash.extensions.denied")));
    }

    public static Set<String> getExtensionsAllowed(ResourceTypeHandler type) {
        return extensionsAllowed.get(type);
    }

    public static void setExtensionsAllowed(ResourceTypeHandler type, String extensionsList) {
        if (extensionsList != null) {
            extensionsAllowed.put(type, Utils.getSet(extensionsList));
            extensionsDenied.get(type).clear();
        }
    }

    public static Set<String> getExtensionsDenied(ResourceTypeHandler type) {
        return extensionsDenied.get(type);
    }

    public static void setExtensionsDenied(ResourceTypeHandler type, String extensionsList) {
        if (extensionsList != null) {
            extensionsDenied.put(type, Utils.getSet(extensionsList));
            extensionsAllowed.get(type).clear();
        }
    }

    public static boolean isAllowed(ResourceTypeHandler type, String extension) {
        if (type == null || extension == null) {
            return false;
        }
        String ext = extension.toLowerCase();
        Set<String> allowed = extensionsAllowed.get(type);
        Set<String> denied = extensionsDenied.get(type);
        if (allowed.isEmpty()) {
            return !denied.contains(ext);
        }
        if (denied.isEmpty()) {
            return allowed.contains(ext);
        }
        return false;
    }
}

