/*
 * Decompiled with CFR 0.152.
 */
package net.fckeditor.handlers;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesLoader {
    private static final Logger logger = LoggerFactory.getLogger(PropertiesLoader.class);
    private static Properties properties = new Properties();

    static {
        InputStream in = PropertiesLoader.class.getResourceAsStream("default.properties");
        if (in == null) {
            logger.error("default.properties not found");
            throw new RuntimeException("default.properties not found");
        }
        if (!(in instanceof BufferedInputStream)) {
            in = new BufferedInputStream(in);
        }
        try {
            properties.load(in);
            in.close();
            logger.debug("default.properties loaded");
        }
        catch (Exception e) {
            logger.error("Error while processing default.properties");
            throw new RuntimeException("Error while processing default.properties", e);
        }
        InputStream in2 = PropertiesLoader.class.getResourceAsStream("/fckeditor.properties_");
        if (in2 == null) {
            logger.info("fckeditor.properties not found");
        } else {
            if (!(in2 instanceof BufferedInputStream)) {
                in2 = new BufferedInputStream(in2);
            }
            try {
                properties.load(in2);
                in2.close();
                logger.debug("fckeditor.properties loaded");
            }
            catch (Exception e) {
                logger.error("Error while processing fckeditor.properties");
                throw new RuntimeException("Error while processing fckeditor.properties", e);
            }
        }
    }

    public static String getProperty(String key) {
        return properties.getProperty(key);
    }

    public static void setProperty(String key, String value) {
        properties.setProperty(key, value);
    }
}

