/*
 * Decompiled with CFR 0.152.
 */
package net.fckeditor.handlers;

import javax.servlet.http.HttpServletRequest;
import net.fckeditor.handlers.PropertiesLoader;
import net.fckeditor.requestcycle.UserAction;
import net.fckeditor.requestcycle.UserPathBuilder;
import net.fckeditor.tool.ReflectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestCycleHandler {
    private static Logger logger;
    private static UserAction userAction;
    private static UserPathBuilder userPathBuilder;

    static {
        Class<?> clazz;
        logger = LoggerFactory.getLogger(RequestCycleHandler.class);
        userAction = null;
        userPathBuilder = null;
        String fqcn = PropertiesLoader.getProperty("connector.userActionImpl");
        if (fqcn == null) {
            logger.warn("No property found for UserAction implementation, any user action will be disabled!");
        } else {
            try {
                clazz = ReflectHelper.classForName(fqcn);
                userAction = (UserAction)clazz.newInstance();
                logger.info("UserAction initialized to {}", userAction.getClass());
            }
            catch (Exception e) {
                logger.error("Couldn't instantiate class [".concat(fqcn).concat("], any user action will disabled!"), (Throwable)e);
            }
        }
        fqcn = PropertiesLoader.getProperty("connector.userPathBuilderImpl");
        if (fqcn == null) {
            logger.warn("No property found for UserPathBuilder implementation! ".concat("The 'DefaultUserFilesPath' will be used in the ConnectorServlet!"));
        } else {
            try {
                clazz = ReflectHelper.classForName(fqcn);
                userPathBuilder = (UserPathBuilder)clazz.newInstance();
                logger.info("UserPathBuilder initialized to {}", userPathBuilder.getClass());
            }
            catch (Exception e) {
                logger.error("Couldn't instantiate class [".concat(fqcn).concat("], The 'DefaultUserFilesPath' will be used in the ConnectorServlet!"), (Throwable)e);
            }
        }
    }

    public static boolean isEnabledForFileBrowsing(HttpServletRequest request) {
        return userAction != null && userAction.isEnabledForFileBrowsing(request);
    }

    public static boolean isEnabledForFileUpload(HttpServletRequest request) {
        return userAction != null && userAction.isEnabledForFileUpload(request);
    }

    protected static String getUserFilePath(HttpServletRequest request) {
        return userPathBuilder != null ? userPathBuilder.getUserFilesPath(request) : null;
    }
}

