/*
 * Decompiled with CFR 0.152.
 */
package net.fckeditor.handlers;

import java.util.HashMap;
import java.util.Map;
import net.fckeditor.handlers.PropertiesLoader;
import net.fckeditor.tool.Utils;

public class ResourceTypeHandler {
    private String name;
    private static Map<String, ResourceTypeHandler> types = new HashMap<String, ResourceTypeHandler>(4);
    private static Map<ResourceTypeHandler, String> paths = new HashMap<ResourceTypeHandler, String>(4);
    public static final ResourceTypeHandler FILE = new ResourceTypeHandler("File");
    public static final ResourceTypeHandler FLASH = new ResourceTypeHandler("Flash");
    public static final ResourceTypeHandler IMAGE = new ResourceTypeHandler("Image");
    public static final ResourceTypeHandler MEDIA = new ResourceTypeHandler("Media");

    static {
        types.put(FILE.getName(), FILE);
        types.put(FLASH.getName(), FLASH);
        types.put(IMAGE.getName(), IMAGE);
        types.put(MEDIA.getName(), MEDIA);
        paths.put(FILE, PropertiesLoader.getProperty("connector.resourceType.file.path"));
        paths.put(IMAGE, PropertiesLoader.getProperty("connector.resourceType.image.path"));
        paths.put(FLASH, PropertiesLoader.getProperty("connector.resourceType.flash.path"));
        paths.put(MEDIA, PropertiesLoader.getProperty("connector.resourceType.media.path"));
    }

    private ResourceTypeHandler(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return paths.get(this);
    }

    public static ResourceTypeHandler valueOf(String name) throws IllegalArgumentException {
        if (Utils.isEmpty(name)) {
            throw new IllegalArgumentException();
        }
        ResourceTypeHandler rt = types.get(name);
        if (rt == null) {
            throw new IllegalArgumentException();
        }
        return rt;
    }

    public static boolean isValid(String name) {
        return types.containsKey(name);
    }

    public static ResourceTypeHandler getDefaultResourceType(String name) {
        ResourceTypeHandler rt = ResourceTypeHandler.getResourceType(name);
        return rt == null ? FILE : rt;
    }

    public static ResourceTypeHandler getResourceType(String name) {
        try {
            return ResourceTypeHandler.valueOf(name);
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        try {
            ResourceTypeHandler rt = (ResourceTypeHandler)obj;
            return this.name.equals(rt.getName());
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }
}

