/*
 * Decompiled with CFR 0.152.
 */
package net.fckeditor.response;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.fckeditor.handlers.CommandHandler;
import net.fckeditor.handlers.ResourceTypeHandler;
import net.fckeditor.tool.Utils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.FileFileFilter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XmlResponse {
    private Document document;
    private Element errorElement;
    private Element foldersElement;
    private Element filesElement;
    public static final int EN_OK = 0;
    public static final int EN_ERROR = 1;
    public static final int EN_ALREADY_EXISTS = 101;
    public static final int EN_INVALID_FOLDER_NAME = 102;
    public static final int EN_SECURITY_ERROR = 103;
    public static final int EN_UKNOWN = 110;

    public XmlResponse(CommandHandler command, ResourceTypeHandler resourceType, String currentFolder, String constructedUrl) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.document = builder.newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        Element root = this.document.createElement("Connector");
        this.document.appendChild(root);
        root.setAttribute("command", command.toString());
        root.setAttribute("resourceType", resourceType.toString());
        Element currentFolderElement = this.document.createElement("CurrentFolder");
        currentFolderElement.setAttribute("path", currentFolder);
        currentFolderElement.setAttribute("url", constructedUrl);
        root.appendChild(currentFolderElement);
    }

    public XmlResponse(int number, String text) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.document = builder.newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        Element root = this.document.createElement("Connector");
        this.document.appendChild(root);
        this.setError(number, text);
    }

    public XmlResponse(int number) {
        this(number, null);
    }

    public void setError(int number, String text) {
        if (this.errorElement == null) {
            this.errorElement = this.document.createElement("Error");
            this.document.getDocumentElement().appendChild(this.errorElement);
        }
        this.errorElement.setAttribute("number", String.valueOf(number));
        if (Utils.isNotEmpty(text)) {
            this.errorElement.setAttribute("text", text);
        }
    }

    public void setError(int number) {
        this.setError(number, null);
    }

    public void setFolders(File dir) {
        String[] fileList;
        if (this.foldersElement != null) {
            Element parent = (Element)this.foldersElement.getParentNode();
            parent.removeChild(this.foldersElement);
        }
        this.foldersElement = this.document.createElement("Folders");
        this.document.getDocumentElement().appendChild(this.foldersElement);
        String[] stringArray = fileList = dir.list((FilenameFilter)DirectoryFileFilter.DIRECTORY);
        int n = fileList.length;
        int n2 = 0;
        while (n2 < n) {
            String file = stringArray[n2];
            Element folderElement = this.document.createElement("Folder");
            folderElement.setAttribute("name", file);
            this.foldersElement.appendChild(folderElement);
            ++n2;
        }
    }

    public void setFiles(File dir) {
        File[] fileList;
        if (this.filesElement != null) {
            Element parent = (Element)this.filesElement.getParentNode();
            parent.removeChild(this.filesElement);
        }
        this.filesElement = this.document.createElement("Files");
        this.document.getDocumentElement().appendChild(this.filesElement);
        File[] fileArray = fileList = dir.listFiles((FileFilter)FileFileFilter.FILE);
        int n = fileList.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            Element fileElement = this.document.createElement("File");
            fileElement.setAttribute("name", file.getName());
            long length = file.length() < 1024L ? 1L : file.length() / 1024L;
            fileElement.setAttribute("size", String.valueOf(length));
            this.filesElement.appendChild(fileElement);
            ++n2;
        }
    }

    public void setFoldersAndFiles(File dir) {
        this.setFolders(dir);
        this.setFiles(dir);
    }

    public String toString() {
        this.document.getDocumentElement().normalize();
        TransformerFactory factory = TransformerFactory.newInstance();
        StringWriter sw = new StringWriter();
        try {
            Transformer transformer = factory.newTransformer();
            DOMSource source = new DOMSource(this.document);
            StreamResult result = new StreamResult(sw);
            transformer.transform(source, result);
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
        return sw.toString();
    }
}

