/*
 * Decompiled with CFR 0.152.
 */
package net.fckeditor.tags;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;
import net.fckeditor.handlers.LocaleResolverHandler;
import net.fckeditor.handlers.RequestCycleHandler;
import net.fckeditor.tool.Compatibility;

public class CheckTag
extends TagSupport {
    private static final long serialVersionUID = -6834095891675681686L;
    private static final String FILE_UPLOAD = "FileUpload";
    private static final String FILE_BROWSING = "FileBrowsing";
    private static final String COMPATIBLE_BROWSER = "CompatibleBrowser";
    private static Set<String> commands = new HashSet<String>(3);
    private String command;

    static {
        commands.add(FILE_UPLOAD);
        commands.add(FILE_BROWSING);
        commands.add(COMPATIBLE_BROWSER);
    }

    public void setCommand(String command) throws JspTagException {
        if (!commands.contains(command)) {
            throw new JspTagException("You have to provide one of the following commands: " + commands);
        }
        this.command = command;
    }

    public int doStartTag() throws JspException {
        JspWriter out = this.pageContext.getOut();
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        LocaleResolverHandler lrh = new LocaleResolverHandler(request);
        String response = null;
        if (this.command.equals(FILE_UPLOAD)) {
            response = RequestCycleHandler.isEnabledForFileUpload(request) ? lrh.getString("message.connector.fileUpload.enabled") : lrh.getString("message.connector.fileUpload.disabled");
        }
        if (this.command.equals(FILE_BROWSING)) {
            response = RequestCycleHandler.isEnabledForFileBrowsing(request) ? lrh.getString("message.connector.fileBrowsing.enabled") : lrh.getString("message.connector.fileBrowsing.disabled");
        }
        if (this.command.equals(COMPATIBLE_BROWSER)) {
            response = Compatibility.isCompatibleBrowser(request) ? lrh.getString("message.compatible_browser.yes") : lrh.getString("message.compatible_browser.no");
        }
        try {
            out.print(response);
        }
        catch (IOException e) {
            throw new JspException("Tag response could not be written to the user!", (Throwable)e);
        }
        return 0;
    }
}

