/*
 * Decompiled with CFR 0.152.
 */
package net.fckeditor.tool;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import net.fckeditor.tool.Utils;

public class Compatibility {
    public static boolean check(String userAgentString) {
        if (Utils.isEmpty(userAgentString)) {
            return false;
        }
        String userAgentStr = userAgentString.toLowerCase();
        if (userAgentStr.indexOf("opera") < 0 && userAgentStr.indexOf("mac") < 0 && Compatibility.getBrowserVersion(userAgentStr, ".*msie ([\\d]+.[\\d]+).*") >= 5.5f) {
            return true;
        }
        if (Compatibility.getBrowserVersion(userAgentStr, ".*rv:([\\d]+.[\\d]+).*") > 1.7f) {
            return true;
        }
        if (Compatibility.getBrowserVersion(userAgentStr, "opera/([\\d]+.[\\d]+).*") >= 9.5f || Compatibility.getBrowserVersion(userAgentStr, ".*opera ([\\d]+.[\\d]+)") >= 9.5f) {
            return true;
        }
        return Compatibility.getBrowserVersion(userAgentStr, ".*applewebkit/([\\d]+).*") >= 522.0f;
    }

    public static boolean isCompatibleBrowser(HttpServletRequest request) {
        return request == null ? false : Compatibility.check(request.getHeader("user-agent"));
    }

    private static float getBrowserVersion(String userAgent, String regex) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(userAgent);
        if (matcher.matches()) {
            try {
                return Float.parseFloat(matcher.group(1));
            }
            catch (NumberFormatException e) {
                return -1.0f;
            }
        }
        return -1.0f;
    }
}

